/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.contributor;

import java.lang.reflect.Type;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.module.extension.internal.loader.java.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.springframework.core.ResolvableType;

public class ParameterTypeUnwrapperContributor
implements ParameterDeclarerContributor {
    private ClassTypeLoader typeLoader;
    private Class<?> classToUnwrap;
    private ModelProperty modelProperty;

    public ParameterTypeUnwrapperContributor(ClassTypeLoader typeLoader, Class classToUnwrap, ModelProperty modelProperty) {
        this.typeLoader = typeLoader;
        this.classToUnwrap = classToUnwrap;
        this.modelProperty = modelProperty;
    }

    @Override
    public void contribute(ExtensionParameter parameter, ParameterDeclarer declarer, ParameterDeclarationContext declarationContext) {
        if (this.classToUnwrap.isAssignableFrom(parameter.getType().getDeclaringClass())) {
            ResolvableType[] generics = ResolvableType.forType((Type)parameter.getJavaType()).getGenerics();
            if (generics.length <= 0) {
                throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] from the Operation [%s] doesn't specify the %s parameterized type", parameter.getName(), declarationContext.getName(), this.classToUnwrap.getSimpleName()));
            }
            Type type = generics[0].getType();
            MetadataType metadataType = this.typeLoader.load(type);
            declarer.ofType(metadataType);
            declarer.withModelProperty(this.modelProperty);
        }
    }
}

