/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class OperationReturnTypeModelValidator
implements ExtensionModelValidator {
    private final Set<String> forbiddenTypes = ImmutableSet.builder().add((Object)Event.class.getName()).add((Object)Message.class.getName()).build();

    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            protected void onOperation(OperationModel operationModel) {
                if (operationModel.getOutput() == null || operationModel.getOutput().getType() == null) {
                    throw OperationReturnTypeModelValidator.this.missingReturnTypeException(extensionModel, operationModel);
                }
                String id = ExtensionMetadataTypeUtils.getId((MetadataType)operationModel.getOutput().getType());
                if (OperationReturnTypeModelValidator.this.forbiddenTypes.contains(id)) {
                    problemsReporter.addError(new Problem((NamedObject)operationModel, String.format("Operation '%s' in Extension '%s' specifies '%s' as a return type. Operations are not allowed to return objects of that type", operationModel.getName(), extensionModel.getName(), id)));
                }
            }
        }.walk(extensionModel);
    }

    private IllegalModelDefinitionException missingReturnTypeException(ExtensionModel model, OperationModel operationModel) {
        throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' in Extension '%s' is missing a return type", operationModel.getName(), model.getName()));
    }
}

