/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.utils;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.ic.internal.error.ConnectivityError;

public class StreamingParameterUtils {
    private static final DataType JAVA_OBJECT = DataType.builder().type(Object.class).mediaType(MediaType.APPLICATION_JAVA).build();
    private static final String PAYLOAD = "payload";
    private static final String EXPRESSION = "#[read(payload)]";
    private static final String UNSUPPORTED_MIME_TYPE_ERROR_MESSAGE = "Unsupported MIME type for the given payload";

    private StreamingParameterUtils() {
    }

    public static Map<String, Object> resolveStreamingParameters(Map<String, Object> parameters, ExpressionLanguage expressionLanguage) {
        HashMap<String, Object> resolvedParameters = new HashMap<String, Object>(parameters);
        for (Map.Entry entry : resolvedParameters.entrySet()) {
            try {
                Object value = entry.getValue();
                if (value instanceof CursorProvider) {
                    CursorProvider cursorProvider = (CursorProvider)value;
                    Cursor cursor = cursorProvider.openCursor();
                    InputStream inputStream = (InputStream)cursor;
                    entry.setValue(StreamingParameterUtils.convert(inputStream, expressionLanguage).getValue());
                    continue;
                }
                if (!(value instanceof InputStream)) continue;
                entry.setValue(StreamingParameterUtils.convert((InputStream)value, expressionLanguage).getValue());
            }
            catch (ModuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)ConnectivityError.CONNECTIVITY, (Throwable)e);
            }
        }
        return resolvedParameters;
    }

    private static <T> TypedValue<T> convert(InputStream inputStream, ExpressionLanguage expressionLanguage) {
        TypedValue payload = TypedValue.of((Object)inputStream);
        BindingContext context = BindingContext.builder().addBinding(PAYLOAD, payload).build();
        try {
            return expressionLanguage.evaluate(EXPRESSION, JAVA_OBJECT, context);
        }
        catch (Exception e) {
            throw new ModuleException(UNSUPPORTED_MIME_TYPE_ERROR_MESSAGE, (ErrorTypeDefinition)MuleErrors.EXPRESSION);
        }
    }
}

