/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.error;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.config.i18n.CoreMessages;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static TypedException throwTypedException(String errorMessage) {
        ErrorType muleAnyErrorType = ExceptionUtils.createMuleAnyErrorType();
        MuleException exception = ExceptionUtils.createMuleException(errorMessage);
        return new TypedException((Throwable)exception, muleAnyErrorType);
    }

    private static MuleException createMuleException(String errorMessage) {
        I18nMessage message = CoreMessages.createStaticMessage((String)errorMessage);
        return new MuleException(message){

            protected void setMessage(I18nMessage msg) {
                try {
                    super.setMessage(msg);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static ErrorType createMuleAnyErrorType() {
        return new ErrorType(){

            public String getNamespace() {
                return "MULE";
            }

            public ErrorType getParentErrorType() {
                return null;
            }

            public String getIdentifier() {
                return "ANY";
            }

            public String toString() {
                return "MULE:ANY";
            }
        };
    }
}

