/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xml.parser;

import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.dsl.api.xml.parser.ConfigLine;
import org.w3c.dom.Node;

public class XmlCustomAttributeHandler {
    public static ConfigLineCustomAttributeStore to(ConfigLine.Builder builder) {
        return new ConfigLineCustomAttributeStore(builder);
    }

    public static class ConfigLineCustomAttributeStore {
        private final ConfigLine.Builder builder;

        private ConfigLineCustomAttributeStore(ConfigLine.Builder builder) {
            this.builder = builder;
        }

        public void addCustomAttributes(Node node) {
            Node nameAttribute = node.getAttributes().getNamedItemNS(Component.Annotations.NAME_ANNOTATION_KEY.getNamespaceURI(), Component.Annotations.NAME_ANNOTATION_KEY.getLocalPart());
            if (nameAttribute != null) {
                this.builder.addCustomAttribute(Component.Annotations.NAME_ANNOTATION_KEY.toString(), nameAttribute.getNodeValue());
            }
            if (node.getPrefix() != null) {
                this.builder.addCustomAttribute("DECLARED_PREFIX", node.getPrefix());
            }
            for (int i = 0; i < node.getAttributes().getLength(); ++i) {
                Node attributeNode = node.getAttributes().item(i);
                if (attributeNode.getNamespaceURI() == null) continue;
                this.builder.addCustomAttribute(new QName(attributeNode.getNamespaceURI(), attributeNode.getLocalName()).toString(), attributeNode.getNodeValue());
            }
        }
    }
}

