/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.core.internal.context.FlowStoppedPersistenceListener;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowStoppedDeploymentPersistenceListener
implements FlowStoppedPersistenceListener {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private AtomicBoolean shouldPersist;
    private String flowName;
    private String appName;
    static final String START_FLOW_ON_DEPLOYMENT_PROPERTY = "startFlowOnDeployment";
    private String propertyName;
    private AtomicBoolean shouldStart;

    public FlowStoppedDeploymentPersistenceListener(String flowName, String appName) {
        this.flowName = flowName;
        this.appName = appName;
        this.propertyName = flowName + "_" + START_FLOW_ON_DEPLOYMENT_PROPERTY;
        this.shouldPersist = new AtomicBoolean(true);
        this.shouldStart = new AtomicBoolean(true);
    }

    public void onStart() {
        try {
            Properties properties = DeploymentPropertiesUtils.resolveFlowDeploymentProperties((String)this.appName, Optional.empty());
            properties.setProperty(this.propertyName, String.valueOf(true));
            DeploymentPropertiesUtils.resolveFlowDeploymentProperties((String)this.appName, Optional.of(properties));
        }
        catch (IOException e) {
            this.logger.error("FlowStoppedDeploymentListener failed to process notification onStart for flow " + this.flowName, (Throwable)e);
        }
    }

    public void onStop() {
        if (!this.shouldPersist.get()) {
            return;
        }
        try {
            Properties properties = DeploymentPropertiesUtils.resolveFlowDeploymentProperties((String)this.appName, Optional.empty());
            properties.setProperty(this.propertyName, String.valueOf(false));
            DeploymentPropertiesUtils.resolveFlowDeploymentProperties((String)this.appName, Optional.of(properties));
        }
        catch (IOException e) {
            this.logger.error("FlowStoppedDeploymentListener failed to process notification onStop for flow " + this.flowName, (Throwable)e);
        }
    }

    public void doNotPersist() {
        this.shouldPersist.set(false);
    }

    public Boolean shouldStart() {
        Properties deploymentProperties = null;
        try {
            deploymentProperties = DeploymentPropertiesUtils.resolveFlowDeploymentProperties((String)this.appName, Optional.empty());
        }
        catch (IOException e) {
            this.logger.error("FlowStoppedDeploymentListener failed to process shouldStart for flow " + this.flowName, (Throwable)e);
        }
        return deploymentProperties != null && Boolean.parseBoolean(deploymentProperties.getProperty(this.propertyName, "true"));
    }
}

