/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.StartupListener;
import org.mule.runtime.module.deployment.internal.CompositeDeploymentListener;
import org.mule.runtime.module.deployment.internal.util.DebuggableReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeploymentService
implements DeploymentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDeploymentService.class);
    private final ReentrantLock deploymentLock = new DebuggableReentrantLock(true);
    private final CompositeDeploymentListener applicationDeploymentListener = new CompositeDeploymentListener();
    private final CompositeDeploymentListener domainDeploymentListener = new CompositeDeploymentListener();
    private final CompositeDeploymentListener domainBundleDeploymentListener = new CompositeDeploymentListener();
    private final List<StartupListener> startupListeners = new CopyOnWriteArrayList<StartupListener>();

    @Override
    public final void addDeploymentListener(DeploymentListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Listener cannot be null");
        this.applicationDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public final void removeDeploymentListener(DeploymentListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Listener cannot be null");
        this.applicationDeploymentListener.removeDeploymentListener(listener);
    }

    @Override
    public final void addDomainBundleDeploymentListener(DeploymentListener listener) {
        this.domainBundleDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public final void removeDomainBundleDeploymentListener(DeploymentListener listener) {
        this.domainBundleDeploymentListener.removeDeploymentListener(listener);
    }

    @Override
    public final void addDomainDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public final void removeDomainDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.removeDeploymentListener(listener);
    }

    @Override
    public final void addStartupListener(StartupListener listener) {
        this.startupListeners.add(listener);
    }

    @Override
    public final void removeStartupListener(StartupListener listener) {
        this.startupListeners.remove(listener);
    }

    public final void notifyStartupListeners() {
        for (StartupListener listener : this.startupListeners) {
            try {
                listener.onAfterStartup();
            }
            catch (Throwable t) {
                LOGGER.error("Error executing startup listener {}", (Object)listener, (Object)t);
            }
        }
    }

    protected Map<String, String> additionalDeploymentProperties() {
        return Collections.emptyMap();
    }

    protected final Optional<Properties> createAdditionalDeploymentProperties() {
        Map<String, String> additionalDeploymentProperties = this.additionalDeploymentProperties();
        if (additionalDeploymentProperties == null || additionalDeploymentProperties.isEmpty()) {
            return Optional.empty();
        }
        Properties properties = new Properties();
        properties.putAll(additionalDeploymentProperties);
        return Optional.of(properties);
    }

    @Override
    public final ReentrantLock getLock() {
        return this.deploymentLock;
    }

    public DeploymentListener getApplicationDeploymentListener() {
        return this.applicationDeploymentListener;
    }

    public DeploymentListener getDomainDeploymentListener() {
        return this.domainDeploymentListener;
    }

    public DeploymentListener getDomainBundleDeploymentListener() {
        return this.domainBundleDeploymentListener;
    }

    public List<StartupListener> getStartupListeners() {
        return this.startupListeners;
    }
}

