/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Optional;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DeploymentUtils.class);

    public static String[] listFiles(File directory, FilenameFilter filter) {
        String[] files = directory.list(filter);
        if (files == null) {
            throw new IllegalStateException(String.format("We got a null while listing the contents of director '%s'. Some common causes for this is a lack of permissions to the directory or that it's being deleted concurrently", directory.getName()));
        }
        return files;
    }

    public static void deployExplodedDomains(ArchiveDeployer<DomainDescriptor, Domain> domainDeployer) {
        String[] domains = DeploymentUtils.listFiles(domainDeployer.getDeploymentDirectory(), (FilenameFilter)DirectoryFileFilter.DIRECTORY);
        DeploymentUtils.deployExplodedDomains(domainDeployer, domains);
    }

    public static void deployExplodedDomains(ArchiveDeployer<DomainDescriptor, Domain> domainDeployer, String[] domains) {
        for (String addedDomain : domains) {
            try {
                if (!domainDeployer.isUpdatedZombieArtifact(addedDomain)) continue;
                domainDeployer.deployExplodedArtifact(addedDomain, Optional.empty());
            }
            catch (DeploymentException e) {
                LOGGER.error("Error deploying domain '{}'", (Object)addedDomain, (Object)e);
            }
        }
    }
}

