/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.CompositeDeploymentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainArchiveDeployer
implements ArchiveDeployer<Domain> {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DOMAIN_BUNDLE_APPS_FOLDER = "apps";
    private final ArchiveDeployer<Domain> domainDeployer;
    private final DeploymentService deploymentService;
    private final ArchiveDeployer<Application> applicationDeployer;

    public DomainArchiveDeployer(ArchiveDeployer<Domain> domainDeployer, ArchiveDeployer<Application> applicationDeployer, DeploymentService deploymentService) {
        this.domainDeployer = domainDeployer;
        this.applicationDeployer = applicationDeployer;
        this.deploymentService = deploymentService;
    }

    @Override
    public boolean isUpdatedZombieArtifact(String artifactName) {
        return true;
    }

    @Override
    public Domain deployPackagedArtifact(String zip) throws DeploymentException {
        return this.domainDeployer.deployPackagedArtifact(zip);
    }

    @Override
    public Domain deployExplodedArtifact(String artifactDir) throws DeploymentException {
        return this.domainDeployer.deployExplodedArtifact(artifactDir);
    }

    @Override
    public Domain deployPackagedArtifact(URI artifactAchivedUrl) {
        return this.domainDeployer.deployPackagedArtifact(artifactAchivedUrl);
    }

    @Override
    public void undeployArtifact(String artifactId) {
        Collection<Application> domainApplications = this.findApplicationsAssociated(artifactId);
        for (Application domainApplication : domainApplications) {
            this.applicationDeployer.undeployArtifact(domainApplication.getArtifactName());
        }
        this.domainDeployer.undeployArtifact(artifactId);
    }

    private Collection<Application> findApplicationsAssociated(String artifactId) {
        Domain domain = this.deploymentService.findDomain(artifactId);
        Preconditions.checkArgument((domain != null ? 1 : 0) != 0, (String)String.format("Domain %s does not exists", artifactId));
        return this.findApplicationsAssociated(domain);
    }

    private Collection<Application> findApplicationsAssociated(Domain domain) {
        return this.deploymentService.findDomainApplications(domain.getArtifactName());
    }

    @Override
    public File getDeploymentDirectory() {
        return this.domainDeployer.getDeploymentDirectory();
    }

    @Override
    public void setDeploymentListener(CompositeDeploymentListener deploymentListener) {
        this.domainDeployer.setDeploymentListener(deploymentListener);
    }

    @Override
    public void redeploy(Domain artifact) throws DeploymentException {
        Collection<Application> domainApplications = this.findApplicationsAssociated(artifact);
        for (Application domainApplication : domainApplications) {
            this.applicationDeployer.undeployArtifactWithoutUninstall(domainApplication);
        }
        try {
            this.domainDeployer.redeploy(artifact);
        }
        catch (DeploymentException e) {
            this.logger.warn(String.format("Failure during redeployment of domain %s, domain applications deployment will be skipped", artifact.getArtifactName()));
            throw e;
        }
        for (Application domainApplication : domainApplications) {
            try {
                this.applicationDeployer.redeploy(domainApplication);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Error redeploying application {}", (Object)domainApplication.getArtifactName(), (Object)e);
            }
        }
    }

    @Override
    public Map<String, Map<URI, Long>> getArtifactsZombieMap() {
        return this.domainDeployer.getArtifactsZombieMap();
    }

    @Override
    public void setArtifactFactory(ArtifactFactory<Domain> artifactFactory) {
        this.domainDeployer.setArtifactFactory(artifactFactory);
    }

    @Override
    public void undeployArtifactWithoutUninstall(Domain artifact) {
        throw new NotImplementedException("undeploy without uninstall is not supported for domains");
    }

    @Override
    public void deployArtifact(Domain artifact) {
        this.domainDeployer.deployArtifact(artifact);
    }
}

