/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.application;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleApplicationClassLoader;
import org.mule.runtime.module.artifact.activation.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;

public class MuleApplicationClassLoaderFactory
implements DeployableArtifactClassLoaderFactory<ApplicationDescriptor> {
    private final NativeLibraryFinderFactory nativeLibraryFinderFactory;

    public MuleApplicationClassLoaderFactory(NativeLibraryFinderFactory nativeLibraryFinderFactory) {
        Preconditions.checkArgument((nativeLibraryFinderFactory != null ? 1 : 0) != 0, (String)"nativeLibraryFinderFactory cannot be null");
        this.nativeLibraryFinderFactory = nativeLibraryFinderFactory;
    }

    public MuleApplicationClassLoaderFactory(Function<String, File> nativeLibsTempFolderChildFunction) {
        this.nativeLibraryFinderFactory = new DefaultNativeLibraryFinderFactory(nativeLibsTempFolderChildFunction);
    }

    public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, ApplicationDescriptor descriptor) {
        ClassLoaderLookupPolicy classLoaderLookupPolicy = this.getApplicationClassLoaderLookupPolicy(parent, descriptor);
        return new MuleApplicationClassLoader(artifactId, (ArtifactDescriptor)descriptor, parent.getClassLoader(), this.nativeLibraryFinderFactory.create(descriptor.getDataFolderName(), descriptor.getLoadedNativeLibrariesFolderName(), descriptor.getClassLoaderConfiguration().getUrls()), Arrays.asList(descriptor.getClassLoaderConfiguration().getUrls()), classLoaderLookupPolicy);
    }

    public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, ApplicationDescriptor descriptor, List<ArtifactClassLoader> artifactPluginClassLoaders) {
        return this.create(artifactId, parent, descriptor);
    }

    private ClassLoaderLookupPolicy getApplicationClassLoaderLookupPolicy(ArtifactClassLoader parent, ApplicationDescriptor descriptor) {
        HashMap pluginsLookupStrategies = new HashMap();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : descriptor.getPlugins()) {
            artifactPluginDescriptor.getClassLoaderConfiguration().getExportedPackages().forEach(p -> pluginsLookupStrategies.put(p, ParentFirstLookupStrategy.PARENT_FIRST));
        }
        return parent.getClassLoaderLookupPolicy().extend(pluginsLookupStrategies);
    }
}

