/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.api.application;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;

public class ApplicationDescriptor
extends DeployableArtifactDescriptor {
    public static final String DEFAULT_CONFIGURATION_RESOURCE = "mule-config.xml";
    public static final String DEFAULT_CONFIGURATION_RESOURCE_LOCATION = Paths.get("mule", "mule-config.xml").toString();
    public static final String REPOSITORY_FOLDER = "repository";
    public static final String PROPERTY_DOMAIN = "domain";
    private String encoding;
    private String domain = "default";
    private Map<String, String> appProperties = new HashMap<String, String>();
    private File logConfigFile;
    private ArtifactDeclaration artifactDeclaration;

    public ApplicationDescriptor(String name) {
        super(name);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Map<String, String> getAppProperties() {
        return this.appProperties;
    }

    public void setAppProperties(Map<String, String> appProperties) {
        this.appProperties = appProperties;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)domain) ? 1 : 0) != 0, (String)"Domain name cannot be empty");
        this.domain = domain;
    }

    public void setLogConfigFile(File logConfigFile) {
        this.logConfigFile = logConfigFile;
    }

    public File getLogConfigFile() {
        return this.logConfigFile;
    }

    public ArtifactDeclaration getArtifactDeclaration() {
        return this.artifactDeclaration;
    }

    public void setArtifactDeclaration(ArtifactDeclaration artifactDeclaration) {
        this.artifactDeclaration = artifactDeclaration;
    }

    @Override
    protected List<String> getDefaultConfigResources() {
        return ImmutableList.builder().add((Object)(MuleFoldersUtil.getAppConfigFolderPath() + DEFAULT_CONFIGURATION_RESOURCE)).build();
    }
}

