/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifactClassLoaderBuilder<T extends AbstractArtifactClassLoaderBuilder> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RegionPluginClassLoadersFactory pluginClassLoadersFactory;
    private List<ArtifactPluginDescriptor> artifactPluginDescriptors = new LinkedList<ArtifactPluginDescriptor>();
    private String artifactId = UUID.getUUID();
    protected ArtifactDescriptor artifactDescriptor;
    private ArtifactClassLoader parentClassLoader;
    protected List<ArtifactClassLoader> artifactPluginClassLoaders = new ArrayList<ArtifactClassLoader>();

    public AbstractArtifactClassLoaderBuilder(RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        Preconditions.checkArgument((pluginClassLoadersFactory != null ? 1 : 0) != 0, (String)"pluginClassLoadersFactory cannot be null");
        this.pluginClassLoadersFactory = pluginClassLoadersFactory;
    }

    protected abstract ArtifactClassLoader getParentClassLoader();

    public T setArtifactId(String artifactId) {
        Preconditions.checkArgument((artifactId != null ? 1 : 0) != 0, (String)"artifact id cannot be null");
        this.artifactId = artifactId;
        return (T)this;
    }

    public T addArtifactPluginDescriptors(ArtifactPluginDescriptor ... artifactPluginDescriptors) {
        Preconditions.checkArgument((artifactPluginDescriptors != null ? 1 : 0) != 0, (String)"artifact plugin descriptors cannot be null");
        this.artifactPluginDescriptors.addAll(Arrays.asList(artifactPluginDescriptors));
        return (T)this;
    }

    public T setArtifactDescriptor(ArtifactDescriptor artifactDescriptor) {
        this.artifactDescriptor = artifactDescriptor;
        return (T)this;
    }

    public ArtifactClassLoader build() throws IOException {
        Preconditions.checkState((this.artifactDescriptor != null ? 1 : 0) != 0, (String)"artifact descriptor cannot be null");
        this.parentClassLoader = this.getParentClassLoader();
        Preconditions.checkState((this.parentClassLoader != null ? 1 : 0) != 0, (String)"parent class loader cannot be null");
        String artifactId = this.getArtifactId(this.artifactDescriptor);
        ClassLoaderLookupPolicy parentLookupPolicy = this.getParentLookupPolicy(this.parentClassLoader);
        RegionClassLoader regionClassLoader = new RegionClassLoader(artifactId, this.artifactDescriptor, this.parentClassLoader.getClassLoader(), parentLookupPolicy);
        ArtifactClassLoaderFilter artifactClassLoaderFilter = this.createArtifactClassLoaderFilter(this.artifactDescriptor.getClassLoaderModel(), parentLookupPolicy);
        HashMap appAdditionalLookupStrategy = new HashMap();
        artifactClassLoaderFilter.getExportedClassPackages().stream().forEach(p -> appAdditionalLookupStrategy.put(p, ParentFirstLookupStrategy.PARENT_FIRST));
        this.artifactPluginClassLoaders = this.pluginClassLoadersFactory.createPluginClassLoaders((ArtifactClassLoader)regionClassLoader, this.artifactPluginDescriptors, regionClassLoader.getClassLoaderLookupPolicy().extend(appAdditionalLookupStrategy));
        ArtifactClassLoader artifactClassLoader = this.createArtifactClassLoader(artifactId, regionClassLoader);
        regionClassLoader.addClassLoader(artifactClassLoader, artifactClassLoaderFilter);
        int artifactPluginIndex = 0;
        for (ArtifactPluginDescriptor artifactPluginDescriptor : this.artifactPluginDescriptors) {
            ArtifactClassLoaderFilter classLoaderFilter = this.createPluginClassLoaderFilter(artifactPluginDescriptor, this.artifactDescriptor.getClassLoaderModel().getExportedPackages(), parentLookupPolicy);
            regionClassLoader.addClassLoader(this.artifactPluginClassLoaders.get(artifactPluginIndex), classLoaderFilter);
            ++artifactPluginIndex;
        }
        return artifactClassLoader;
    }

    protected ClassLoaderLookupPolicy getParentLookupPolicy(ArtifactClassLoader parentClassLoader) {
        return parentClassLoader.getClassLoaderLookupPolicy();
    }

    protected abstract ArtifactClassLoader createArtifactClassLoader(String var1, RegionClassLoader var2);

    private ArtifactClassLoaderFilter createArtifactClassLoaderFilter(ClassLoaderModel classLoaderModel, ClassLoaderLookupPolicy classLoaderLookupPolicy) {
        Set<String> artifactExportedPackages = this.sanitizeExportedPackages(classLoaderLookupPolicy, classLoaderModel.getExportedPackages());
        return new DefaultArtifactClassLoaderFilter(artifactExportedPackages, classLoaderModel.getExportedResources());
    }

    private ArtifactClassLoaderFilter createPluginClassLoaderFilter(ArtifactPluginDescriptor pluginDescriptor, Set<String> parentArtifactExportedPackages, ClassLoaderLookupPolicy classLoaderLookupPolicy) {
        Set<String> sanitizedArtifactExportedPackages = this.sanitizeExportedPackages(classLoaderLookupPolicy, pluginDescriptor.getClassLoaderModel().getExportedPackages());
        Set replacedPackages = parentArtifactExportedPackages.stream().filter(p -> sanitizedArtifactExportedPackages.contains(p)).collect(Collectors.toSet());
        if (!replacedPackages.isEmpty()) {
            sanitizedArtifactExportedPackages.removeAll(replacedPackages);
            this.logger.warn("Exported packages from plugin '" + pluginDescriptor.getName() + "' are provided by the artifact owner: " + replacedPackages);
        }
        return new DefaultArtifactClassLoaderFilter(sanitizedArtifactExportedPackages, pluginDescriptor.getClassLoaderModel().getExportedResources());
    }

    private Set<String> sanitizeExportedPackages(ClassLoaderLookupPolicy classLoaderLookupPolicy, Set<String> artifactExportedPackages) {
        HashSet<String> sanitizedArtifactExportedPackages = new HashSet<String>(artifactExportedPackages);
        Set containerProvidedPackages = sanitizedArtifactExportedPackages.stream().filter(p -> {
            LookupStrategy lookupStrategy = classLoaderLookupPolicy.getPackageLookupStrategy(p);
            return !(lookupStrategy instanceof ChildFirstLookupStrategy);
        }).collect(Collectors.toSet());
        if (!containerProvidedPackages.isEmpty()) {
            sanitizedArtifactExportedPackages.removeAll(containerProvidedPackages);
            this.logger.warn("Exported packages from artifact '" + this.artifactDescriptor.getName() + "' are provided by parent class loader: " + containerProvidedPackages);
        }
        return sanitizedArtifactExportedPackages;
    }

    protected abstract String getArtifactId(ArtifactDescriptor var1);
}

