/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;

public class ApplicationDescriptorFactory
extends AbstractDeployableDescriptorFactory<MuleApplicationModel, org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor> {
    public static final String SYSTEM_PROPERTY_OVERRIDE = "-O";

    public ApplicationDescriptorFactory(ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        super(artifactPluginDescriptorLoader, descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
    }

    @Override
    protected void doDescriptorConfig(MuleApplicationModel artifactModel, org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor descriptor, File artifactLocation) {
        super.doDescriptorConfig(artifactModel, descriptor, artifactLocation);
        artifactModel.getDomain().ifPresent(arg_0 -> ((org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor)descriptor).setDomainName(arg_0));
    }

    protected org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor createArtifactDescriptor(File artifactLocation, String name, Optional<Properties> deploymentProperties) {
        return new ApplicationDescriptor(artifactLocation.getName(), deploymentProperties);
    }

    @Override
    protected String getDefaultConfigurationResource() {
        return "mule-config.xml";
    }

    protected ArtifactType getArtifactType() {
        return ArtifactType.APP;
    }

    protected AbstractMuleArtifactModelJsonSerializer<MuleApplicationModel> getMuleArtifactModelJsonSerializer() {
        return new MuleApplicationModelJsonSerializer();
    }

    void setApplicationProperties(org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor desc, File appPropsFile) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (appPropsFile.exists() && appPropsFile.canRead()) {
            Properties props;
            try {
                props = PropertiesUtils.loadProperties((URL)appPropsFile.toURI().toURL());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to obtain application properties file URL", e);
            }
            for (Object key : props.keySet()) {
                m.put(key.toString(), props.getProperty(key.toString()));
            }
        }
        Properties sysProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(SYSTEM_PROPERTY_OVERRIDE)) continue;
            m.put(key.substring(SYSTEM_PROPERTY_OVERRIDE.length()), entry.getValue().toString());
        }
        desc.setAppProperties(m);
    }
}

