/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.util.JarUtils;
import org.mule.runtime.deployment.model.api.artifact.DescriptorLoaderRepositoryFactory;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.artifact.api.plugin.LoaderDescriber;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedBundleDescriptorAttributes;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedClassLoaderConfigurationAttributes;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedDeploymentProperties;

public class ArtifactPluginDescriptorFactory
extends AbstractArtifactDescriptorFactory<MulePluginModel, ArtifactPluginDescriptor> {
    public ArtifactPluginDescriptorFactory() {
        this(new DescriptorLoaderRepositoryFactory().createDescriptorLoaderRepository(), ArtifactDescriptorValidatorBuilder.builder());
    }

    public ArtifactPluginDescriptorFactory(DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        super(descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
    }

    public ArtifactPluginDescriptor create(File pluginJarFile, Optional<Properties> deploymentProperties) throws ArtifactDescriptorCreateException {
        try {
            Preconditions.checkArgument((pluginJarFile.isDirectory() || pluginJarFile.getName().endsWith(".jar") ? 1 : 0) != 0, (String)("provided file is not a plugin: " + pluginJarFile.getAbsolutePath()));
            String mulePluginJsonPathInsideJarFile = "META-INF/mule-artifact/mule-artifact.json";
            Optional jsonDescriptorContentOptional = JarUtils.loadFileContentFrom((File)pluginJarFile, (String)mulePluginJsonPathInsideJarFile);
            return jsonDescriptorContentOptional.map(jsonDescriptorContent -> (ArtifactPluginDescriptor)this.loadFromJsonDescriptor(pluginJarFile, this.loadModelFromJson(new String((byte[])jsonDescriptorContent)), deploymentProperties)).orElseThrow(() -> new ArtifactDescriptorCreateException(ArtifactPluginDescriptorFactory.pluginDescriptorNotFound(pluginJarFile, mulePluginJsonPathInsideJarFile)));
        }
        catch (ArtifactDescriptorCreateException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ArtifactDescriptorCreateException((Throwable)e);
        }
    }

    protected Map<String, Object> getClassLoaderConfigurationAttributes(Optional<Properties> deploymentPropertiesOptional, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, BundleDescriptor bundleDescriptor) {
        Properties deploymentProperties;
        Map attributes = super.getClassLoaderConfigurationAttributes(deploymentPropertiesOptional, classLoaderModelLoaderDescriptor, bundleDescriptor);
        if (deploymentPropertiesOptional.isPresent() && (deploymentProperties = deploymentPropertiesOptional.get()) instanceof PluginExtendedDeploymentProperties) {
            PluginExtendedDeploymentProperties pluginExtendedDeploymentProperties = (PluginExtendedDeploymentProperties)deploymentProperties;
            return new PluginExtendedClassLoaderConfigurationAttributes(attributes, pluginExtendedDeploymentProperties.getDeployableArtifactDescriptor());
        }
        return attributes;
    }

    protected Map<String, Object> getBundleDescriptorAttributes(MuleArtifactLoaderDescriptor bundleDescriptorLoader, Optional<Properties> deploymentPropertiesOptional) {
        Properties deploymentProperties;
        Map attributes = super.getBundleDescriptorAttributes(bundleDescriptorLoader, deploymentPropertiesOptional);
        if (deploymentPropertiesOptional.isPresent() && (deploymentProperties = deploymentPropertiesOptional.get()) instanceof PluginExtendedDeploymentProperties) {
            PluginExtendedDeploymentProperties pluginExtendedDeploymentProperties = (PluginExtendedDeploymentProperties)deploymentProperties;
            return new PluginExtendedBundleDescriptorAttributes(attributes, pluginExtendedDeploymentProperties.getPluginBundleDescriptor());
        }
        return attributes;
    }

    protected ArtifactType getArtifactType() {
        return ArtifactType.PLUGIN;
    }

    protected void doDescriptorConfig(MulePluginModel artifactModel, ArtifactPluginDescriptor descriptor, File artifactLocation) {
        artifactModel.getExtensionModelLoaderDescriptor().ifPresent(extensionModelDescriptor -> {
            LoaderDescriber loaderDescriber = new LoaderDescriber(extensionModelDescriptor.getId());
            loaderDescriber.addAttributes(extensionModelDescriptor.getAttributes());
            descriptor.setExtensionModelDescriptorProperty(loaderDescriber);
        });
        artifactModel.getLicense().ifPresent(arg_0 -> ((ArtifactPluginDescriptor)descriptor).setLicenseModel(arg_0));
    }

    protected ArtifactPluginDescriptor createArtifactDescriptor(File artifactLocation, String name, Optional<Properties> deploymentProperties) {
        return new ArtifactPluginDescriptor(name);
    }

    private static String pluginDescriptorNotFound(File pluginFile, String mulePluginJsonPathInsideJarFile) {
        return String.format("The plugin descriptor '%s' on plugin file '%s' is not present", mulePluginJsonPathInsideJarFile, pluginFile);
    }

    protected AbstractMuleArtifactModelJsonSerializer<MulePluginModel> getMuleArtifactModelJsonSerializer() {
        return new MulePluginModelJsonSerializer();
    }
}

