/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.internal.memory.management.ArtifactMemoryManagementService;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationWrapper;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultMuleApplication;
import org.mule.runtime.module.deployment.impl.internal.application.MuleApplicationPolicyProvider;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.AmbiguousDomainReferenceException;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.domain.IncompatibleDomainException;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyInstanceProviderFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyTemplateFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;

public class DefaultApplicationFactory
extends AbstractDeployableArtifactFactory<ApplicationDescriptor, Application>
implements ArtifactFactory<ApplicationDescriptor, Application> {
    private final ApplicationDescriptorFactory applicationDescriptorFactory;
    private final DomainRepository domainRepository;
    private final ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory;
    private final ServiceRepository serviceRepository;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    private final LicenseValidator licenseValidator;

    public DefaultApplicationFactory(ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory, ApplicationDescriptorFactory applicationDescriptorFactory, DomainRepository domainRepository, ServiceRepository serviceRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, ClassLoaderRepository classLoaderRepository, PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory, PluginDependenciesResolver pluginDependenciesResolver, ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, LicenseValidator licenseValidator, LockFactory runtimeLockFactory, MemoryManagementService memoryManagementService, ArtifactConfigurationProcessor artifactConfigurationProcessor) {
        super(licenseValidator, runtimeLockFactory, memoryManagementService, artifactConfigurationProcessor);
        Preconditions.checkArgument((applicationClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"Application classloader builder factory cannot be null");
        Preconditions.checkArgument((applicationDescriptorFactory != null ? 1 : 0) != 0, (String)"Application descriptor factory cannot be null");
        Preconditions.checkArgument((domainRepository != null ? 1 : 0) != 0, (String)"Domain repository cannot be null");
        Preconditions.checkArgument((serviceRepository != null ? 1 : 0) != 0, (String)"Service repository cannot be null");
        Preconditions.checkArgument((extensionModelLoaderRepository != null ? 1 : 0) != 0, (String)"extensionModelLoaderRepository cannot be null");
        Preconditions.checkArgument((classLoaderRepository != null ? 1 : 0) != 0, (String)"classLoaderRepository cannot be null");
        Preconditions.checkArgument((policyTemplateClassLoaderBuilderFactory != null ? 1 : 0) != 0, (String)"policyClassLoaderBuilderFactory cannot be null");
        Preconditions.checkArgument((pluginDependenciesResolver != null ? 1 : 0) != 0, (String)"pluginDependenciesResolver cannot be null");
        Preconditions.checkArgument((artifactPluginDescriptorLoader != null ? 1 : 0) != 0, (String)"artifactPluginDescriptorLoader cannot be null");
        Preconditions.checkArgument((memoryManagementService != null ? 1 : 0) != 0, (String)"memoryManagementService cannot be null");
        Preconditions.checkArgument((artifactConfigurationProcessor != null ? 1 : 0) != 0, (String)"artifactConfigurationProcessor cannot be null");
        this.classLoaderRepository = classLoaderRepository;
        this.applicationClassLoaderBuilderFactory = applicationClassLoaderBuilderFactory;
        this.applicationDescriptorFactory = applicationDescriptorFactory;
        this.domainRepository = domainRepository;
        this.serviceRepository = serviceRepository;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.policyTemplateClassLoaderBuilderFactory = policyTemplateClassLoaderBuilderFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.artifactPluginDescriptorLoader = artifactPluginDescriptorLoader;
        this.licenseValidator = licenseValidator;
    }

    @Override
    protected Application doCreateArtifact(File artifactDir, Optional<Properties> properties) throws IOException {
        String appName = artifactDir.getName();
        if (appName.contains(" ")) {
            throw new IllegalArgumentException("Mule application name may not contain spaces: " + appName);
        }
        ApplicationDescriptor descriptor = this.createArtifactDescriptor(artifactDir, properties);
        return this.createArtifact(descriptor);
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleAppsDir();
    }

    public ApplicationDescriptor createArtifactDescriptor(File artifactLocation, Optional<Properties> deploymentProperties) {
        return (ApplicationDescriptor)this.applicationDescriptorFactory.create(artifactLocation, deploymentProperties);
    }

    public Application createArtifact(ApplicationDescriptor descriptor) throws IOException {
        Domain domain = this.getDomainForDescriptor(descriptor);
        List resolvedArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(((DomainDescriptor)domain.getDescriptor()).getPlugins(), new ArrayList<ArtifactPluginDescriptor>(this.getArtifactPluginDescriptors(descriptor)), true);
        LinkedHashSet resolvedArtifactPlugins = new LinkedHashSet();
        resolvedArtifactPlugins.addAll(resolvedArtifactPluginDescriptors);
        descriptor.setPlugins(resolvedArtifactPlugins);
        ApplicationClassLoaderBuilder artifactClassLoaderBuilder = this.applicationClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader applicationClassLoader = artifactClassLoaderBuilder.setDomainParentClassLoader((ArtifactClassLoader)domain.getArtifactClassLoader().getClassLoader().getParent()).setArtifactDescriptor((ArtifactDescriptor)descriptor).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(applicationClassLoader, resolvedArtifactPluginDescriptors);
        MuleApplicationPolicyProvider applicationPolicyProvider = new MuleApplicationPolicyProvider(new DefaultPolicyTemplateFactory(this.policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver, this.licenseValidator), new DefaultPolicyInstanceProviderFactory(this.serviceRepository, this.classLoaderRepository, this.extensionModelLoaderRepository, this.getArtifactConfigurationProcessor()));
        DefaultMuleApplication delegate = new DefaultMuleApplication(descriptor, applicationClassLoader, artifactPlugins, this.domainRepository, this.serviceRepository, this.extensionModelLoaderRepository, descriptor.getArtifactLocation(), this.classLoaderRepository, applicationPolicyProvider, this.getRuntimeLockFactory(), (MemoryManagementService)new ArtifactMemoryManagementService(this.getMemoryManagementService()), this.getArtifactConfigurationProcessor());
        applicationPolicyProvider.setApplication(delegate);
        return new ApplicationWrapper(delegate);
    }

    private Domain getDomainForDescriptor(ApplicationDescriptor descriptor) {
        try {
            return DefaultMuleApplication.getApplicationDomain(this.domainRepository, descriptor);
        }
        catch (DomainNotFoundException e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)String.format("Domain '%s' has to be deployed in order to deploy Application '%s'", e.getDomainName(), descriptor.getName())), (Throwable)((Object)e));
        }
        catch (IncompatibleDomainException e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Domain was found, but the bundle descriptor is incompatible"), (Throwable)((Object)e));
        }
        catch (AmbiguousDomainReferenceException e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Multiple domains were found"), (Throwable)((Object)e));
        }
    }

    private Set<ArtifactPluginDescriptor> getArtifactPluginDescriptors(ApplicationDescriptor descriptor) {
        if (descriptor.getPlugins().isEmpty()) {
            HashSet<ArtifactPluginDescriptor> pluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
            for (BundleDependency bundleDependency : descriptor.getClassLoaderModel().getDependencies()) {
                if (!bundleDependency.getDescriptor().isPlugin()) continue;
                File pluginZip = new File(bundleDependency.getBundleUri());
                try {
                    pluginDescriptors.add(this.artifactPluginDescriptorLoader.load(pluginZip, bundleDependency.getDescriptor(), (ArtifactDescriptor)descriptor));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot create plugin descriptor: " + pluginZip.getAbsolutePath(), e);
                }
            }
            return pluginDescriptors;
        }
        return descriptor.getPlugins();
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader applicationClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)applicationClassLoader.getArtifactId(), (String)artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, applicationClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }
}

