/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Plugin;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.deployment.impl.internal.maven.ArtifactClassLoaderModelBuilder;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginLocalDependenciesDenylist;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class HeavyweightClassLoaderModelBuilder
extends ArtifactClassLoaderModelBuilder {
    public static final Semver CLASS_LOADER_MODEL_VERSION_110 = new Semver("1.1.0", Semver.SemverType.LOOSE);
    private final ClassLoaderModel packagerClassLoaderModel;
    private Semver classLoaderModelVersion;

    public HeavyweightClassLoaderModelBuilder(File applicationFolder, BundleDescriptor artifactBundleDescriptor, ClassLoaderModel packagerClassLoaderModel) {
        super(applicationFolder, artifactBundleDescriptor);
        this.packagerClassLoaderModel = packagerClassLoaderModel;
        this.classLoaderModelVersion = new Semver(packagerClassLoaderModel.getVersion(), Semver.SemverType.LOOSE);
    }

    @Override
    protected void doExportSharedLibrariesResourcesAndPackages(Plugin packagingPlugin) {
        if (new Semver(this.packagerClassLoaderModel.getVersion(), Semver.SemverType.LOOSE).isLowerThan(CLASS_LOADER_MODEL_VERSION_110)) {
            super.doExportSharedLibrariesResourcesAndPackages(packagingPlugin);
        } else {
            this.exportSharedLibrariesResourcesAndPackages();
        }
    }

    @Override
    protected Map<BundleDescriptor, List<BundleDescriptor>> doProcessAdditionalPluginLibraries(Plugin packagingPlugin) {
        if (this.packagerClassLoaderModel instanceof AppClassLoaderModel) {
            AppClassLoaderModel appClassLoaderModel = (AppClassLoaderModel)this.packagerClassLoaderModel;
            appClassLoaderModel.getAdditionalPluginDependencies().ifPresent(additionalDeps -> additionalDeps.forEach(this::updateDependency));
        }
        return Collections.emptyMap();
    }

    @Override
    protected List<URI> processPluginAdditionalDependenciesURIs(BundleDependency bundleDependency) {
        return bundleDependency.getAdditionalDependenciesList().stream().map(additionalDependency -> {
            if (this.isSupportingPackagesResourcesInformation() && !PluginLocalDependenciesDenylist.isDenylisted(additionalDependency.getDescriptor())) {
                this.withLocalPackages(additionalDependency.getPackages());
                this.withLocalResources(additionalDependency.getResources());
            }
            return additionalDependency.getBundleUri();
        }).collect(Collectors.toList());
    }

    private BundleDependency createExtendedBundleDependency(BundleDependency original, List<BundleDependency> additionalPluginDependencies) {
        return new BundleDependency.Builder(original).setAdditionalDependencies(additionalPluginDependencies).build();
    }

    private void updateDependency(org.mule.tools.api.classloader.model.Plugin plugin) {
        this.dependencies.stream().filter(dep -> this.areSameDependency(plugin, (BundleDependency)dep)).findFirst().ifPresent(pluginDependency -> this.replaceBundleDependency((BundleDependency)pluginDependency, this.createExtendedBundleDependency((BundleDependency)pluginDependency, plugin.getAdditionalDependencies().stream().map(this::toBundleDependency).collect(Collectors.toList()))));
    }

    private boolean areSameDependency(org.mule.tools.api.classloader.model.Plugin plugin, BundleDependency dependency) {
        return StringUtils.equals((CharSequence)dependency.getDescriptor().getGroupId(), (CharSequence)plugin.getGroupId()) && StringUtils.equals((CharSequence)dependency.getDescriptor().getArtifactId(), (CharSequence)plugin.getArtifactId());
    }

    private BundleDependency toBundleDependency(Artifact artifact) {
        BundleDependency.Builder builder = new BundleDependency.Builder();
        if (artifact.getArtifactCoordinates().getScope() != null) {
            builder.setScope(BundleScope.valueOf((String)artifact.getArtifactCoordinates().getScope().toUpperCase()));
        }
        BundleDependency.Builder bundleDependencyBuilder = builder.setBundleUri(artifact.getUri().isAbsolute() ? artifact.getUri() : new File(this.artifactFolder, artifact.getUri().toString()).toURI()).setDescriptor(new BundleDescriptor.Builder().setArtifactId(artifact.getArtifactCoordinates().getArtifactId()).setGroupId(artifact.getArtifactCoordinates().getGroupId()).setVersion(artifact.getArtifactCoordinates().getVersion()).setClassifier(artifact.getArtifactCoordinates().getClassifier()).setType(artifact.getArtifactCoordinates().getType()).build());
        if (this.isSupportingPackagesResourcesInformation()) {
            bundleDependencyBuilder.setPackages((Set)(artifact.getPackages() == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(artifact.getPackages()))));
            bundleDependencyBuilder.setResources((Set)(artifact.getResources() == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(artifact.getResources()))));
        }
        return bundleDependencyBuilder.build();
    }

    private boolean isSupportingPackagesResourcesInformation() {
        return !this.classLoaderModelVersion.isLowerThan("1.2.0");
    }

    private void exportSharedLibrariesResourcesAndPackages() {
        this.packagerClassLoaderModel.getDependencies().stream().filter(Artifact::isShared).filter(sharedDep -> !this.validateMuleRuntimeSharedLibrary(sharedDep.getArtifactCoordinates().getGroupId(), sharedDep.getArtifactCoordinates().getArtifactId())).forEach(sharedDep -> {
            if (this.isSupportingPackagesResourcesInformation()) {
                this.exportingPackages(sharedDep.getPackages() == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(sharedDep.getPackages())));
                this.exportingResources(sharedDep.getResources() == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(sharedDep.getResources())));
            } else {
                this.findAndExportSharedLibrary(sharedDep.getArtifactCoordinates().getGroupId(), sharedDep.getArtifactCoordinates().getArtifactId());
            }
        });
    }
}

