/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy.proxy;

import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.internal.MetadataInvocationHandler;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.reflections.ReflectionUtils;

public class LifecycleFilterProxy<T>
extends MetadataInvocationHandler<T> {
    private final Set<Method> lifecycleMethods;

    private LifecycleFilterProxy(T object, Set<Method> lifecycleMethods) {
        super(object);
        this.lifecycleMethods = lifecycleMethods;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.lifecycleMethods.contains(method)) {
            return null;
        }
        return this.doInvoke(proxy, method, args);
    }

    public static <T> T createLifecycleFilterProxy(T object) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (String)"object cannot be null");
        Set lifecycleMethods = ReflectionUtils.getAllMethods(object.getClass(), (Predicate[])new Predicate[]{method -> method.getDeclaringClass() == Startable.class || method.getDeclaringClass() == Stoppable.class || method.getDeclaringClass() == Disposable.class || method.getName().equals("setMuleContext") || method.isAnnotationPresent(Inject.class)});
        if (lifecycleMethods.isEmpty()) {
            return object;
        }
        LifecycleFilterProxy<T> handler = new LifecycleFilterProxy<T>(object, lifecycleMethods);
        return (T)Proxy.newProxyInstance(object.getClass().getClassLoader(), ClassUtils.findImplementedInterfaces(object.getClass()), handler);
    }
}

