/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.application.DeployableMavenClassLoaderModelLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginMavenClassLoaderModelLoader;
import org.mule.runtime.module.service.internal.artifact.LibFolderClassLoaderModelLoader;

public class MavenClassLoaderModelLoader
implements ClassLoaderModelLoader {
    private DeployableMavenClassLoaderModelLoader deployableMavenClassLoaderModelLoader;
    private PluginMavenClassLoaderModelLoader pluginMavenClassLoaderModelLoader;
    private LibFolderClassLoaderModelLoader libFolderClassLoaderModelLoader;
    private final MavenClientProvider mavenClientProvider;
    private MavenConfiguration mavenRuntimeConfig;
    private StampedLock lock = new StampedLock();

    public MavenClassLoaderModelLoader() {
        this.mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)MavenClientProvider.class.getClassLoader());
        this.mavenRuntimeConfig = GlobalConfigLoader.getMavenConfig();
        this.createClassLoaderModelLoaders();
    }

    private void createClassLoaderModelLoaders() {
        MavenClient mavenClient = this.mavenClientProvider.createMavenClient(this.mavenRuntimeConfig);
        File localMavenRepositoryLocation = mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation();
        File temporaryFolder = new File(localMavenRepositoryLocation, ".mule");
        this.deployableMavenClassLoaderModelLoader = new DeployableMavenClassLoaderModelLoader(mavenClient, temporaryFolder);
        this.pluginMavenClassLoaderModelLoader = new PluginMavenClassLoaderModelLoader(mavenClient, temporaryFolder);
        this.libFolderClassLoaderModelLoader = new LibFolderClassLoaderModelLoader();
    }

    public String getId() {
        return "mule";
    }

    public ClassLoaderModel load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        long stamp = this.lock.readLock();
        try {
            MavenConfiguration updatedMavenConfiguration = GlobalConfigLoader.getMavenConfig();
            if (!this.mavenRuntimeConfig.equals(updatedMavenConfiguration)) {
                long writeStamp = this.lock.tryConvertToWriteLock(stamp);
                if (writeStamp == 0L) {
                    this.lock.unlockRead(stamp);
                    stamp = this.lock.writeLock();
                } else {
                    stamp = writeStamp;
                }
                if (!this.mavenRuntimeConfig.equals(updatedMavenConfiguration)) {
                    this.mavenRuntimeConfig = updatedMavenConfiguration;
                    this.createClassLoaderModelLoaders();
                }
            }
            if (this.deployableMavenClassLoaderModelLoader.supportsArtifactType(artifactType)) {
                ClassLoaderModel classLoaderModel = this.deployableMavenClassLoaderModelLoader.load(artifactFile, attributes, artifactType);
                return classLoaderModel;
            }
            if (this.pluginMavenClassLoaderModelLoader.supportsArtifactType(artifactType)) {
                ClassLoaderModel classLoaderModel = this.pluginMavenClassLoaderModelLoader.load(artifactFile, attributes, artifactType);
                return classLoaderModel;
            }
            if (this.libFolderClassLoaderModelLoader.supportsArtifactType(artifactType)) {
                ClassLoaderModel classLoaderModel = this.libFolderClassLoaderModelLoader.load(artifactFile, attributes, artifactType);
                return classLoaderModel;
            }
            throw new IllegalStateException(String.format("Artifact type %s not supported", artifactType));
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    public boolean supportsArtifactType(ArtifactType artifactType) {
        return this.deployableMavenClassLoaderModelLoader.supportsArtifactType(artifactType) || this.pluginMavenClassLoaderModelLoader.supportsArtifactType(artifactType) || this.libFolderClassLoaderModelLoader.supportsArtifactType(artifactType);
    }
}

