/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.util.Map;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.registry.CompositeMuleRegistryHelper;
import org.mule.runtime.core.internal.registry.DefaultRegistryBroker;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.RegistryBroker;
import org.mule.runtime.module.deployment.impl.internal.application.SupportsPropertiesMuleContextBuilder;

public class ApplicationMuleContextBuilder
extends SupportsPropertiesMuleContextBuilder {
    private final String appName;
    private final String defaultEncoding;
    private final MuleContext parentContext;

    public ApplicationMuleContextBuilder(String appName, Map<String, String> appProperties, String defaultEncoding, MuleContext parentContext) {
        super(ArtifactType.APP, appProperties);
        this.appName = appName;
        this.defaultEncoding = defaultEncoding;
        this.parentContext = parentContext;
    }

    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration configuration = new DefaultMuleConfiguration(true);
        this.initializeFromProperties((MuleConfiguration)configuration);
        configuration.setId(this.appName);
        String encoding = this.defaultEncoding;
        if (!StringUtils.isBlank((String)encoding)) {
            configuration.setDefaultEncoding(encoding);
        }
        return configuration;
    }

    protected MuleRegistryHelper getMuleRegistry(DefaultMuleContext muleContext) {
        if (this.parentContext != null && ((DefaultMuleContext)this.parentContext).getRegistry() instanceof MuleRegistryHelper) {
            DefaultRegistryBroker registryBroker = new DefaultRegistryBroker((MuleContext)muleContext, muleContext.getLifecycleInterceptor());
            muleContext.setRegistryBroker((RegistryBroker)registryBroker);
            return new CompositeMuleRegistryHelper(registryBroker, (MuleContext)muleContext, ((DefaultMuleContext)this.parentContext).getRegistry());
        }
        return super.getMuleRegistry(muleContext);
    }
}

