/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.descriptor.InvalidDescriptorLoaderException;

public class FileSystemPolicyClassLoaderModelLoader
implements ClassLoaderModelLoader {
    public static final String FILE_SYSTEM_POLICY_MODEL_LOADER_ID = "FILE_SYSTEM_POLICY_MODEL_LOADER";
    protected static final String LIB_DIR = "lib";
    public static final String CLASSES_DIR = "classes";
    private static final String JAR_FILE = ".jar";

    public String getId() {
        return FILE_SYSTEM_POLICY_MODEL_LOADER_ID;
    }

    public ClassLoaderModel load(File artifactFolder, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder = new ClassLoaderModel.ClassLoaderModelBuilder();
        this.loadUrls(classLoaderModelBuilder, artifactFolder);
        return classLoaderModelBuilder.build();
    }

    public boolean supportsArtifactType(ArtifactType artifactType) {
        return true;
    }

    private void loadUrls(ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder, File artifactFolder) throws InvalidDescriptorLoaderException {
        try {
            classLoaderModelBuilder.containing(new File(artifactFolder, CLASSES_DIR).toURI().toURL());
            File libDir = new File(artifactFolder, LIB_DIR);
            if (libDir.exists()) {
                File[] jars = libDir.listFiles((FilenameFilter)new SuffixFileFilter(JAR_FILE));
                for (int i = 0; i < jars.length; ++i) {
                    classLoaderModelBuilder.containing(jars[i].toURI().toURL());
                }
            }
        }
        catch (MalformedURLException e) {
            throw new InvalidDescriptorLoaderException("Failed to create plugin descriptor " + artifactFolder);
        }
    }
}

