/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.deployment.model.api.plugin.LoaderDescriber;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleExtensionModelLoaderManager
implements ExtensionModelLoaderManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ArtifactClassLoader containerClassLoader;
    private final Map<String, ExtensionModelLoader> extensionModelLoaders = Maps.newHashMap();

    public MuleExtensionModelLoaderManager(ArtifactClassLoader containerClassLoader) {
        Preconditions.checkNotNull((Object)containerClassLoader, (String)"containerClassLoader cannot be null");
        this.containerClassLoader = containerClassLoader;
    }

    public void start() throws MuleException {
        Class<ExtensionModelLoader> providerClass = ExtensionModelLoader.class;
        SpiServiceRegistry spiServiceRegistry = new SpiServiceRegistry();
        ClassLoader classLoader = this.containerClassLoader.getClassLoader();
        Collection extensionModelLoaders = spiServiceRegistry.lookupProviders(providerClass, classLoader);
        StringBuilder sb = new StringBuilder();
        extensionModelLoaders.stream().collect(Collectors.groupingBy(ExtensionModelLoader::getId)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
            String classes = ((List)entry.getValue()).stream().map(extensionModelLoader -> extensionModelLoader.getClass().getName()).collect(Collectors.joining(", "));
            sb.append(System.lineSeparator()).append("ID [").append((String)entry.getKey()).append("] is being returned by the following classes [").append(classes).append("]");
        });
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There are several loaders that return the same identifier when looking up providers for '%s'. Full error list: %s", providerClass.getName(), sb.toString())));
        }
        extensionModelLoaders.stream().forEach(extensionModelLoader -> this.extensionModelLoaders.put(extensionModelLoader.getId(), (ExtensionModelLoader)extensionModelLoader));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ExtensionModelLoader registered identifiers: {}", (Object)this.printExtensionModelLoaderIDs());
        }
    }

    public void stop() throws MuleException {
        this.extensionModelLoaders.clear();
    }

    public Optional<ExtensionModelLoader> getExtensionModelLoader(LoaderDescriber loaderDescriber) {
        return this.extensionModelLoaders.containsKey(loaderDescriber.getId()) ? Optional.of(this.extensionModelLoaders.get(loaderDescriber.getId())) : Optional.empty();
    }

    private String printExtensionModelLoaderIDs() {
        return this.extensionModelLoaders.keySet().stream().collect(Collectors.joining(", "));
    }

    public String toString() {
        return String.format("%s[extensionModelLoaders=%s]", this.getClass().getName(), this.printExtensionModelLoaderIDs());
    }
}

