/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContextConfiguration;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.serializer.ArtifactObjectSerializer;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationMuleContextBuilder;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactBootstrapServiceDiscovererConfigurationBuilder;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactExtensionManagerConfigurationBuilder;
import org.mule.runtime.module.deployment.impl.internal.artifact.CompositeArtifactExtensionManagerFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ConnectionManagerConfigurationBuilder;
import org.mule.runtime.module.deployment.impl.internal.artifact.ContainerServicesMuleContextConfigurator;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainMuleContextBuilder;
import org.mule.runtime.module.deployment.impl.internal.policy.ArtifactExtensionManagerFactory;
import org.mule.runtime.module.extension.api.manager.DefaultExtensionManagerFactory;
import org.mule.runtime.module.extension.api.manager.ExtensionManagerFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.module.service.ServiceRepository;

public class ArtifactContextBuilder {
    protected static final String EXECUTION_CLASSLOADER_WAS_NOT_SET = "Execution classloader was not set";
    protected static final String MULE_CONTEXT_ARTIFACT_PROPERTIES_CANNOT_BE_NULL = "MuleContext artifact properties cannot be null";
    protected static final String INSTALLATION_DIRECTORY_MUST_BE_A_DIRECTORY = "installation directory must be a directory";
    protected static final String ONLY_APPLICATIONS_ARE_ALLOWED_TO_HAVE_A_PARENT_ARTIFACT = "Only applications are allowed to have a parent artifact";
    protected static final String SERVICE_REPOSITORY_CANNOT_BE_NULL = "serviceRepository cannot be null";
    protected static final String EXTENSION_MODEL_LOADER_REPOSITORY_CANNOT_BE_NULL = "extensionModelLoaderRepository cannot be null";
    protected static final String CLASS_LOADER_REPOSITORY_CANNOT_BE_NULL = "classLoaderRepository cannot be null";
    protected static final String CLASS_LOADER_REPOSITORY_WAS_NOT_SET = "classLoaderRepository was not set";
    protected static final String SERVICE_CONFIGURATOR_CANNOT_BE_NULL = "serviceConfigurator cannot be null";
    private List<ArtifactPlugin> artifactPlugins = new ArrayList<ArtifactPlugin>();
    private ArtifactType artifactType = ArtifactType.APP;
    private String[] configurationFiles = new String[0];
    private ArtifactDeclaration artifactDeclaration;
    private Map<String, String> artifactProperties = new HashMap<String, String>();
    private String artifactName = UUID.getUUID();
    private MuleContextBuilder muleContextBuilder;
    private ClassLoader executionClassLoader;
    private File artifactInstallationDirectory;
    private MuleContextListener muleContextListener;
    private String defaultEncoding;
    private ServiceRepository serviceRepository = Collections::emptyList;
    private ExtensionModelLoaderRepository extensionModelLoaderRepository = loaderDescriber -> Optional.empty();
    private boolean enableLazyInit;
    private boolean disableXmlValidations;
    private List<ConfigurationBuilder> additionalBuilders = Collections.emptyList();
    private ClassLoaderRepository classLoaderRepository;
    private PolicyProvider policyProvider;
    private List<ServiceConfigurator> serviceConfigurators = new ArrayList<ServiceConfigurator>();
    private ExtensionManagerFactory extensionManagerFactory;
    private DeployableArtifact parentArtifact;

    private ArtifactContextBuilder() {
    }

    public static ArtifactContextBuilder newBuilder() {
        return new ArtifactContextBuilder();
    }

    public static ArtifactContextBuilder newBuilder(ConfigurationBuilder ... additionalBuilders) {
        ArtifactContextBuilder builder = new ArtifactContextBuilder();
        builder.setAdditionalBuilders(Arrays.asList(additionalBuilders));
        return builder;
    }

    private void setAdditionalBuilders(List<ConfigurationBuilder> additionalBuilders) {
        this.additionalBuilders = additionalBuilders;
    }

    public ArtifactContextBuilder setArtifactType(ArtifactType artifactType) {
        this.artifactType = artifactType;
        return this;
    }

    public ArtifactContextBuilder setConfigurationFiles(String ... configurationFiles) {
        this.configurationFiles = configurationFiles;
        return this;
    }

    public ArtifactContextBuilder setArtifactDeclaration(ArtifactDeclaration artifactDeclaration) {
        this.artifactDeclaration = artifactDeclaration;
        return this;
    }

    public ArtifactContextBuilder serParenArtifact(DeployableArtifact parentArtifact) {
        this.parentArtifact = parentArtifact;
        return this;
    }

    public ArtifactContextBuilder setArtifactProperties(Map<String, String> artifactProperties) {
        Preconditions.checkArgument((artifactProperties != null ? 1 : 0) != 0, (String)MULE_CONTEXT_ARTIFACT_PROPERTIES_CANNOT_BE_NULL);
        this.artifactProperties = artifactProperties;
        return this;
    }

    public ArtifactContextBuilder setArtifactName(String artifactName) {
        this.artifactName = artifactName;
        return this;
    }

    public ArtifactContextBuilder setMuleContextListener(MuleContextListener muleContextListener) {
        this.muleContextListener = muleContextListener;
        return this;
    }

    public ArtifactContextBuilder setArtifactInstallationDirectory(File location) {
        Preconditions.checkArgument((boolean)location.isDirectory(), (String)INSTALLATION_DIRECTORY_MUST_BE_A_DIRECTORY);
        this.artifactInstallationDirectory = location;
        return this;
    }

    public ArtifactContextBuilder setExecutionClassloader(ClassLoader classloader) {
        this.executionClassLoader = classloader;
        return this;
    }

    public ArtifactContextBuilder setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    public ArtifactContextBuilder setArtifactPlugins(List<ArtifactPlugin> artifactPlugins) {
        this.artifactPlugins = artifactPlugins;
        return this;
    }

    public ArtifactContextBuilder setServiceRepository(ServiceRepository serviceRepository) {
        Preconditions.checkArgument((serviceRepository != null ? 1 : 0) != 0, (String)SERVICE_REPOSITORY_CANNOT_BE_NULL);
        this.serviceRepository = serviceRepository;
        return this;
    }

    public ArtifactContextBuilder setExtensionModelLoaderRepository(ExtensionModelLoaderRepository extensionModelLoaderRepository) {
        Preconditions.checkArgument((extensionModelLoaderRepository != null ? 1 : 0) != 0, (String)EXTENSION_MODEL_LOADER_REPOSITORY_CANNOT_BE_NULL);
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        return this;
    }

    public ArtifactContextBuilder setPolicyProvider(PolicyProvider policyProvider) {
        this.policyProvider = policyProvider;
        return this;
    }

    public ArtifactContextBuilder setEnableLazyInit(boolean enableLazyInit) {
        this.enableLazyInit = enableLazyInit;
        return this;
    }

    public ArtifactContextBuilder setDisableXmlValidations(boolean disableXmlValidations) {
        this.disableXmlValidations = disableXmlValidations;
        return this;
    }

    public ArtifactContextBuilder setClassLoaderRepository(ClassLoaderRepository classLoaderRepository) {
        Preconditions.checkState((classLoaderRepository != null ? 1 : 0) != 0, (String)CLASS_LOADER_REPOSITORY_CANNOT_BE_NULL);
        this.classLoaderRepository = classLoaderRepository;
        return this;
    }

    public ArtifactContextBuilder withServiceConfigurator(ServiceConfigurator serviceConfigurator) {
        Preconditions.checkState((serviceConfigurator != null ? 1 : 0) != 0, (String)SERVICE_CONFIGURATOR_CANNOT_BE_NULL);
        this.serviceConfigurators.add(serviceConfigurator);
        return this;
    }

    public ArtifactContext build() throws InitialisationException, ConfigurationException {
        Preconditions.checkState((this.executionClassLoader != null ? 1 : 0) != 0, (String)EXECUTION_CLASSLOADER_WAS_NOT_SET);
        Preconditions.checkState((this.classLoaderRepository != null ? 1 : 0) != 0, (String)CLASS_LOADER_REPOSITORY_WAS_NOT_SET);
        Preconditions.checkState((ArtifactType.APP.equals((Object)this.artifactType) || this.parentArtifact == null ? 1 : 0) != 0, (String)ONLY_APPLICATIONS_ARE_ALLOWED_TO_HAVE_A_PARENT_ARTIFACT);
        try {
            return (ArtifactContext)ClassUtils.withContextClassLoader((ClassLoader)this.executionClassLoader, () -> {
                LinkedList<Object> builders = new LinkedList<Object>();
                builders.addAll(this.additionalBuilders);
                builders.add((Object)new ArtifactBootstrapServiceDiscovererConfigurationBuilder(this.artifactPlugins));
                if (this.extensionManagerFactory == null) {
                    this.extensionManagerFactory = this.parentArtifact == null ? new ArtifactExtensionManagerFactory(this.artifactPlugins, this.extensionModelLoaderRepository, (ExtensionManagerFactory)new DefaultExtensionManagerFactory()) : new CompositeArtifactExtensionManagerFactory(this.parentArtifact, this.extensionModelLoaderRepository, this.artifactPlugins, (ExtensionManagerFactory)new DefaultExtensionManagerFactory());
                }
                builders.add((Object)new ArtifactExtensionManagerConfigurationBuilder(this.artifactPlugins, this.extensionManagerFactory));
                builders.add(this.createConfigurationBuilderFromApplicationProperties());
                final ArtifactConfigurationProcessor artifactConfigurationProcessor = ArtifactConfigurationProcessor.discover();
                final AtomicReference artifactContext = new AtomicReference();
                builders.add(new ConfigurationBuilder(){
                    public boolean isConfigured;

                    public void configure(MuleContext muleContext) throws ConfigurationException {
                        if (ArtifactContextBuilder.this.serviceRepository != null) {
                            ArtifactContextBuilder.this.serviceConfigurators.add(new ContainerServicesMuleContextConfigurator(ArtifactContextBuilder.this.serviceRepository));
                        }
                        if (ArtifactContextBuilder.this.classLoaderRepository != null) {
                            ArtifactContextBuilder.this.serviceConfigurators.add(customizationService -> customizationService.registerCustomServiceImpl("_muleClassLoaderRepository", (Object)ArtifactContextBuilder.this.classLoaderRepository));
                        }
                        if (ArtifactContextBuilder.this.policyProvider != null) {
                            ArtifactContextBuilder.this.serviceConfigurators.add(customizationService -> customizationService.registerCustomServiceImpl("_mulePolicyProvider", (Object)ArtifactContextBuilder.this.policyProvider));
                        }
                        ArtifactContextConfiguration.ArtifactContextConfigurationBuilder artifactContextConfigurationBuilder = ArtifactContextConfiguration.builder().setMuleContext(muleContext).setConfigResources(ArtifactContextBuilder.this.configurationFiles).setArtifactDeclaration(ArtifactContextBuilder.this.artifactDeclaration).setArtifactProperties(ArtifactContextBuilder.this.artifactProperties).setArtifactType(ArtifactContextBuilder.this.artifactType).setEnableLazyInitialization(ArtifactContextBuilder.this.enableLazyInit).setDisableXmlValidations(ArtifactContextBuilder.this.disableXmlValidations).setServiceConfigurators(ArtifactContextBuilder.this.serviceConfigurators);
                        if (ArtifactContextBuilder.this.parentArtifact != null) {
                            artifactContextConfigurationBuilder.setParentContext((MuleContext)ArtifactContextBuilder.this.parentArtifact.getRegistry().lookupByType(MuleContext.class).get());
                        }
                        artifactContext.set(artifactConfigurationProcessor.createArtifactContext(artifactContextConfigurationBuilder.build()));
                    }

                    public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
                    }
                });
                DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
                if (this.muleContextListener != null) {
                    muleContextFactory.addListener(this.muleContextListener);
                }
                this.muleContextBuilder = ArtifactType.APP.equals((Object)this.artifactType) ? new ApplicationMuleContextBuilder(this.artifactName, this.artifactProperties, this.defaultEncoding) : new DomainMuleContextBuilder(this.artifactName);
                this.muleContextBuilder.setExecutionClassLoader(this.executionClassLoader);
                ArtifactObjectSerializer objectSerializer = new ArtifactObjectSerializer(this.classLoaderRepository);
                this.muleContextBuilder.setObjectSerializer((ObjectSerializer)objectSerializer);
                if (this.parentArtifact != null) {
                    builders.add(new ConnectionManagerConfigurationBuilder(this.parentArtifact));
                    this.muleContextBuilder.setErrorTypeRepository(ErrorTypeRepositoryFactory.createCompositeErrorTypeRepository((ErrorTypeRepository)((MuleContext)this.parentArtifact.getRegistry().lookupByType(MuleContext.class).get()).getErrorTypeRepository()));
                } else {
                    builders.add(new ConnectionManagerConfigurationBuilder());
                }
                try {
                    muleContextFactory.createMuleContext(builders, this.muleContextBuilder);
                    return (ArtifactContext)artifactContext.get();
                }
                catch (InitialisationException e) {
                    throw new ConfigurationException((Throwable)e);
                }
            });
        }
        catch (MuleRuntimeException e) {
            if (e.getCause() instanceof InitialisationException) {
                throw (InitialisationException)e.getCause();
            }
            if (e.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getCause();
            }
            throw e;
        }
    }

    protected ConfigurationBuilder createConfigurationBuilderFromApplicationProperties() {
        if (this.artifactInstallationDirectory != null) {
            this.artifactProperties.put("app.home", this.artifactInstallationDirectory.getAbsolutePath());
        }
        this.artifactProperties.put("app.name", this.artifactName);
        return new SimpleConfigurationBuilder(this.artifactProperties);
    }

    public ArtifactContextBuilder setExtensionManagerFactory(ExtensionManagerFactory extensionManagerFactory) {
        this.extensionManagerFactory = extensionManagerFactory;
        return this;
    }
}

