/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.util.JarUtils;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.LoaderDescriber;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.artifact.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.LoaderNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.artifact.ServiceRegistryDescriptorLoaderRepository;

public class ArtifactPluginDescriptorFactory
implements ArtifactDescriptorFactory<ArtifactPluginDescriptor> {
    private final DescriptorLoaderRepository descriptorLoaderRepository;

    public ArtifactPluginDescriptorFactory() {
        this(new ServiceRegistryDescriptorLoaderRepository((ServiceRegistry)new SpiServiceRegistry()));
    }

    public ArtifactPluginDescriptorFactory(DescriptorLoaderRepository descriptorLoaderRepository) {
        Preconditions.checkArgument((descriptorLoaderRepository != null ? 1 : 0) != 0, (String)"descriptorLoaderRepository cannot be null");
        this.descriptorLoaderRepository = descriptorLoaderRepository;
    }

    public ArtifactPluginDescriptor create(File pluginJarFile) throws ArtifactDescriptorCreateException {
        try {
            Preconditions.checkArgument((pluginJarFile.isDirectory() || pluginJarFile.getName().endsWith(".jar") ? 1 : 0) != 0, (String)("provided file is not a plugin: " + pluginJarFile.getAbsolutePath()));
            String mulePluginJsonPathInsideJarFile = "META-INF/mule-artifact/mule-plugin.json";
            Optional jsonDescriptorContentOptional = JarUtils.loadFileContentFrom((File)pluginJarFile, (String)mulePluginJsonPathInsideJarFile);
            return jsonDescriptorContentOptional.map(jsonDescriptorContent -> this.loadFromJsonDescriptor(pluginJarFile, new String((byte[])jsonDescriptorContent))).orElseThrow(() -> new ArtifactDescriptorCreateException(ArtifactPluginDescriptorFactory.pluginDescriptorNotFound(pluginJarFile, mulePluginJsonPathInsideJarFile)));
        }
        catch (ArtifactDescriptorCreateException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ArtifactDescriptorCreateException((Throwable)e);
        }
    }

    private ArtifactPluginDescriptor loadFromJsonDescriptor(File pluginJarFile, String jsonDescriptorContent) {
        MulePluginModel mulePluginModel = this.getMulePluginJsonDescriber(jsonDescriptorContent);
        ArtifactPluginDescriptor descriptor = new ArtifactPluginDescriptor(mulePluginModel.getName());
        mulePluginModel.getClassLoaderModelLoaderDescriptor().ifPresent(classLoaderModelLoaderDescriptor -> descriptor.setClassLoaderModel(this.getClassLoaderModel(pluginJarFile, (MuleArtifactLoaderDescriptor)classLoaderModelLoaderDescriptor)));
        descriptor.setBundleDescriptor(this.getBundleDescriptor(pluginJarFile, mulePluginModel));
        mulePluginModel.getExtensionModelLoaderDescriptor().ifPresent(extensionModelDescriptor -> {
            LoaderDescriber loaderDescriber = new LoaderDescriber(extensionModelDescriptor.getId());
            loaderDescriber.addAttributes(extensionModelDescriptor.getAttributes());
            descriptor.setExtensionModelDescriptorProperty(loaderDescriber);
        });
        return descriptor;
    }

    private BundleDescriptor getBundleDescriptor(File pluginFolder, MulePluginModel mulePluginModel) {
        BundleDescriptorLoader bundleDescriptorLoader;
        try {
            bundleDescriptorLoader = this.descriptorLoaderRepository.get(mulePluginModel.getBundleDescriptorLoader().getId(), ArtifactType.PLUGIN, BundleDescriptorLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(ArtifactPluginDescriptorFactory.invalidBundleDescriptorLoaderIdError(pluginFolder, mulePluginModel.getBundleDescriptorLoader()));
        }
        try {
            return (BundleDescriptor)bundleDescriptorLoader.load(pluginFolder, mulePluginModel.getBundleDescriptorLoader().getAttributes(), ArtifactType.PLUGIN);
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException((Throwable)e);
        }
    }

    private ClassLoaderModel getClassLoaderModel(File pluginJarFile, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor) {
        ClassLoaderModel classLoaderModel;
        ClassLoaderModelLoader classLoaderModelLoader;
        try {
            classLoaderModelLoader = this.descriptorLoaderRepository.get(classLoaderModelLoaderDescriptor.getId(), ArtifactType.PLUGIN, ClassLoaderModelLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(ArtifactPluginDescriptorFactory.invalidClassLoaderModelIdError(pluginJarFile, classLoaderModelLoaderDescriptor));
        }
        try {
            classLoaderModel = (ClassLoaderModel)classLoaderModelLoader.load(pluginJarFile, classLoaderModelLoaderDescriptor.getAttributes(), ArtifactType.PLUGIN);
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException((Throwable)e);
        }
        return classLoaderModel;
    }

    protected static String pluginDescriptorNotFound(File pluginFile, String mulePluginJsonPathInsideJarFile) {
        return String.format("The plugin descriptor '%s' on plugin file '%s' is not present", mulePluginJsonPathInsideJarFile, pluginFile);
    }

    protected static String invalidBundleDescriptorLoaderIdError(File pluginFolder, MuleArtifactLoaderDescriptor bundleDescriptorLoader) {
        return String.format("The identifier '%s' for a bundle descriptor loader is not supported (error found while reading plugin '%s')", bundleDescriptorLoader.getId(), pluginFolder.getAbsolutePath());
    }

    protected static String invalidClassLoaderModelIdError(File pluginFolder, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor) {
        return String.format("The identifier '%s' for a class loader model descriptor is not supported (error found while reading plugin '%s')", classLoaderModelLoaderDescriptor.getId(), pluginFolder.getAbsolutePath());
    }

    private MulePluginModel getMulePluginJsonDescriber(String jsonDescriptorContent) {
        return (MulePluginModel)new MulePluginModelJsonSerializer().deserialize(jsonDescriptorContent);
    }
}

