/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;

public class PropertiesDescriptorParser {
    public static final String PROPERTY_REDEPLOYMENT_ENABLED = "redeployment.enabled";
    protected static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_DOMAIN = "domain";
    public static final String PROPERTY_CONFIG_RESOURCES = "config.resources";
    protected static final String PROPERTY_LOG_CONFIG_FILE = "log.configFile";

    public ApplicationDescriptor parse(File location, File descriptor, String artifactName) throws IOException {
        Properties properties = PropertiesUtils.loadProperties((InputStream)new FileInputStream(descriptor));
        ApplicationDescriptor appDescriptor = new ApplicationDescriptor(artifactName);
        appDescriptor.setEncoding(properties.getProperty(PROPERTY_ENCODING));
        appDescriptor.setDomain(properties.getProperty(PROPERTY_DOMAIN));
        appDescriptor.setArtifactLocation(location);
        appDescriptor.setRootFolder(location.getParentFile());
        String resProps = properties.getProperty(PROPERTY_CONFIG_RESOURCES);
        ArrayList<String> urls = new ArrayList<String>();
        if (StringUtils.isBlank((String)resProps)) {
            urls.add("mule" + File.separator + "mule-config.xml");
        } else {
            List<String> configs = Arrays.asList(resProps.split(","));
            configs.stream().forEach(config -> urls.add(MuleFoldersUtil.getAppConfigFolderPath() + config));
        }
        appDescriptor.setConfigResources(urls);
        String[] absoluteResourcePaths = this.convertConfigResourcesToAbsolutePatch(urls, location);
        appDescriptor.setAbsoluteResourcePaths(absoluteResourcePaths);
        appDescriptor.setConfigResourcesFile(this.convertConfigResourcesToFile(absoluteResourcePaths));
        appDescriptor.setRedeploymentEnabled(BooleanUtils.toBoolean((String)properties.getProperty(PROPERTY_REDEPLOYMENT_ENABLED, Boolean.TRUE.toString())));
        if (properties.containsKey(PROPERTY_LOG_CONFIG_FILE)) {
            appDescriptor.setLogConfigFile(new File(properties.getProperty(PROPERTY_LOG_CONFIG_FILE)));
        }
        return appDescriptor;
    }

    private File[] convertConfigResourcesToFile(String[] absoluteResourcePaths) {
        File[] configResourcesFile = new File[absoluteResourcePaths.length];
        for (int i = 0; i < absoluteResourcePaths.length; ++i) {
            configResourcesFile[i] = new File(absoluteResourcePaths[i]);
        }
        return configResourcesFile;
    }

    private String[] convertConfigResourcesToAbsolutePatch(List<String> configResources, File location) {
        String[] absoluteResourcePaths = new String[configResources.size()];
        for (int i = 0; i < configResources.size(); ++i) {
            String resource = configResources.get(i);
            absoluteResourcePaths[i] = this.toAbsoluteFile(resource, location);
        }
        return absoluteResourcePaths;
    }

    protected String toAbsoluteFile(String path, File location) {
        return location.getAbsolutePath() + File.separator + path;
    }
}

