/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.discoverer.ModuleDiscoverer;
import org.mule.runtime.jpms.api.MuleContainerModule;

public class CompositeModuleDiscoverer
implements ModuleDiscoverer {
    private final ModuleDiscoverer[] moduleDiscoverers;

    public CompositeModuleDiscoverer(ModuleDiscoverer ... moduleDiscoverers) {
        Preconditions.checkArgument((moduleDiscoverers.length > 0 ? 1 : 0) != 0, (String)"moduleDiscoverers cannot be empty");
        this.moduleDiscoverers = moduleDiscoverers;
    }

    @Override
    public List<MuleContainerModule> discover() {
        ArrayList<MuleContainerModule> muleModules = new ArrayList<MuleContainerModule>();
        for (ModuleDiscoverer discoverer : this.moduleDiscoverers) {
            muleModules.addAll(discoverer.discover());
        }
        return muleModules;
    }
}

