/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathModuleDiscoverer
implements ModuleDiscoverer {
    private static Logger logger = LoggerFactory.getLogger(ClasspathModuleDiscoverer.class);
    public static final String MODULE_PROPERTIES = "META-INF/mule-module.properties";
    public static final String EXPORTED_CLASS_PACKAGES_PROPERTY = "artifact.export.classPackages";
    public static final String PRIVILEGED_EXPORTED_CLASS_PACKAGES_PROPERTY = "artifact.privileged.classPackages";
    public static final String PRIVILEGED_ARTIFACTS_PROPERTY = "artifact.privileged.artifactIds";
    public static final String EXPORTED_RESOURCE_PROPERTY = "artifact.export.resources";
    public static final String EXPORTED_SERVICES_PROPERTY = "artifact.export.services";
    private final ClassLoader classLoader;
    private final File temporaryFolder;

    public ClasspathModuleDiscoverer(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.temporaryFolder = this.createModulesTemporaryFolder();
    }

    protected File createModulesTemporaryFolder() {
        File modulesTempFolder = MuleFoldersUtil.getModulesTempFolder();
        if (modulesTempFolder.exists()) {
            try {
                FileUtils.cleanDirectory((File)modulesTempFolder);
            }
            catch (IOException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not clean up folder %s, validate that the process has permissions over that directory", modulesTempFolder.getAbsolutePath())));
            }
        } else if (!modulesTempFolder.mkdirs()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create folder %s, validate that the process has permissions over that directory", modulesTempFolder.getAbsolutePath())));
        }
        return modulesTempFolder;
    }

    @Override
    public List<MuleModule> discover() {
        LinkedList<MuleModule> modules = new LinkedList<MuleModule>();
        HashSet<String> moduleNames = new HashSet<String>();
        try {
            for (Properties moduleProperties : PropertiesUtils.discoverProperties((ClassLoader)this.classLoader, (String)this.getModulePropertiesFileName())) {
                MuleModule module = this.createModule(moduleProperties);
                if (moduleNames.contains(module.getName())) {
                    logger.warn(String.format("Ignoring duplicated module '%s'", module.getName()));
                    continue;
                }
                moduleNames.add(module.getName());
                modules.add(module);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot discover mule modules", e);
        }
        return modules;
    }

    protected String getModulePropertiesFileName() {
        return MODULE_PROPERTIES;
    }

    private MuleModule createModule(Properties moduleProperties) {
        String moduleName = (String)moduleProperties.get("module.name");
        Set<String> modulePackages = this.getExportedPackageByProperty(moduleProperties, EXPORTED_CLASS_PACKAGES_PROPERTY);
        Set<String> modulePaths = this.getExportedResourcePaths(moduleProperties);
        Set<String> modulePrivilegedPackages = this.getExportedPackageByProperty(moduleProperties, PRIVILEGED_EXPORTED_CLASS_PACKAGES_PROPERTY);
        Set<String> privilegedArtifacts = this.getPrivilegedArtifactIds(moduleProperties);
        List<ExportedService> exportedServices = this.getExportedServices(moduleProperties, EXPORTED_SERVICES_PROPERTY);
        return new MuleModule(moduleName, modulePackages, modulePaths, modulePrivilegedPackages, privilegedArtifacts, exportedServices);
    }

    private List<ExportedService> getExportedServices(Properties moduleProperties, String exportedServicesProperty) {
        String privilegedExportedPackagesProperty = (String)moduleProperties.get(exportedServicesProperty);
        List<ExportedService> exportedServices = !StringUtils.isEmpty((CharSequence)privilegedExportedPackagesProperty) ? this.getServicesFromProperty(privilegedExportedPackagesProperty) : new ArrayList<ExportedService>();
        return exportedServices;
    }

    private List<ExportedService> getServicesFromProperty(String privilegedExportedPackagesProperty) {
        ArrayList<ExportedService> exportedServices = new ArrayList<ExportedService>();
        for (String exportedServiceDefinition : privilegedExportedPackagesProperty.split(",")) {
            URL resource;
            String[] split = exportedServiceDefinition.split(":");
            String serviceInterface = split[0];
            String serviceImplementation = split[1];
            try {
                File serviceFile = Files.createTempFile(this.temporaryFolder.toPath(), serviceInterface, "tmp", new FileAttribute[0]).toFile();
                serviceFile.deleteOnExit();
                org.mule.runtime.core.api.util.FileUtils.stringToFile((String)serviceFile.getAbsolutePath(), (String)serviceImplementation);
                resource = serviceFile.toURI().toURL();
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error creating temporary service provider file for '%s'", serviceInterface), e);
            }
            exportedServices.add(new ExportedService(serviceInterface, resource));
        }
        return exportedServices;
    }

    private Set<String> getPrivilegedArtifactIds(Properties moduleProperties) {
        String privilegedArtifactsProperty = (String)moduleProperties.get(PRIVILEGED_ARTIFACTS_PROPERTY);
        HashSet<String> artifactsIds = new HashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)privilegedArtifactsProperty)) {
            for (String artifactName : privilegedArtifactsProperty.split(",")) {
                if (StringUtils.isEmpty((CharSequence)artifactName.trim())) continue;
                artifactsIds.add(artifactName);
            }
        }
        HashSet<String> privilegedArtifacts = artifactsIds;
        return privilegedArtifacts;
    }

    private Set<String> getExportedPackageByProperty(Properties moduleProperties, String privilegedExportedClassPackagesProperty) {
        String privilegedExportedPackagesProperty = (String)moduleProperties.get(privilegedExportedClassPackagesProperty);
        Set<String> modulePrivilegedPackages = !StringUtils.isEmpty((CharSequence)privilegedExportedPackagesProperty) ? this.getPackagesFromProperty(privilegedExportedPackagesProperty) : new HashSet<String>();
        return modulePrivilegedPackages;
    }

    private Set<String> getExportedResourcePaths(Properties moduleProperties) {
        HashSet<String> paths = new HashSet<String>();
        String exportedResourcesProperty = (String)moduleProperties.get(EXPORTED_RESOURCE_PROPERTY);
        if (!StringUtils.isEmpty((CharSequence)exportedResourcesProperty)) {
            for (String path : exportedResourcesProperty.split(",")) {
                if (StringUtils.isEmpty((CharSequence)path.trim())) continue;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                paths.add(path);
            }
        }
        return paths;
    }

    private Set<String> getPackagesFromProperty(String privilegedExportedPackagesProperty) {
        HashSet<String> packages = new HashSet<String>();
        for (String packageName : privilegedExportedPackagesProperty.split(",")) {
            if (StringUtils.isEmpty((CharSequence)(packageName = packageName.trim()))) continue;
            packages.add(packageName);
        }
        return packages;
    }
}

