/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mule.module.artifact.classloader.ActiveMQResourceReleaser;
import org.mule.module.artifact.classloader.AwsIdleConnectionReaperResourceReleaser;
import org.mule.module.artifact.classloader.ClassLoaderResourceReleaser;
import org.mule.module.artifact.classloader.GroovyResourceReleaser;
import org.mule.module.artifact.classloader.IBMMQResourceReleaser;
import org.mule.module.artifact.classloader.MvelClassLoaderReleaser;
import org.mule.module.artifact.classloader.ScalaClassValueReleaser;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DirectoryResourceLocator;
import org.mule.runtime.module.artifact.api.classloader.FineGrainedControlClassLoader;
import org.mule.runtime.module.artifact.api.classloader.LocalResourceLocator;
import org.mule.runtime.module.artifact.api.classloader.ModuleLayerInformationSupplier;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.mule.runtime.module.artifact.api.classloader.ShutdownListener;
import org.mule.runtime.module.artifact.api.classloader.jar.CachingURLStreamHandlerFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.internal.classloader.ResourceReleaserExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleArtifactClassLoader
extends FineGrainedControlClassLoader
implements ArtifactClassLoader {
    private static final Logger LOGGER;
    private static final String DB_RESOURCE_RELEASER_CLASS_LOCATION = "/org/mule/module/artifact/classloader/JdbcResourceReleaser.class";
    static final Pattern DOT_REPLACEMENT_PATTERN;
    static final String PATH_SEPARATOR = "/";
    static final String RESOURCE_PREFIX = "resource::";
    static final String WILDCARD = "*";
    private static final String NO_WILDCARD = "([^\\*]+)";
    private static final String NO_WILDCARD_NO_SPACES = "([^\\*|\\s]+)";
    private static final String NO_SPACES = "([^\\s]+)";
    static final Pattern GAV_EXTENDED_PATTERN;
    private static final Pattern MAVEN_ARTIFACT_PATTERN;
    private static final boolean IS_JAVA_VERSION_AT_MOST_11;
    protected List<ShutdownListener> shutdownListeners = new ArrayList<ShutdownListener>();
    private final String artifactId;
    private final Object localResourceLocatorLock = new Object();
    private volatile LocalResourceLocator localResourceLocator;
    private String dbResourceReleaserClassLocation = "/org/mule/module/artifact/classloader/JdbcResourceReleaser.class";
    private volatile boolean shouldReleaseJdbcReferences = false;
    private volatile boolean shouldReleaseIbmMQResources = false;
    private volatile boolean shouldReleaseActiveMQReferences = false;
    private volatile boolean shouldReleaseGroovyReferences = false;
    private ResourceReleaser jdbcResourceReleaserInstance;
    private final ArtifactDescriptor artifactDescriptor;
    private final Object descriptorMappingLock = new Object();
    private final Map<BundleDescriptor, URLClassLoader> descriptorMapping = new HashMap<BundleDescriptor, URLClassLoader>();
    private final ResourceReleaserExecutor resourceReleaserExecutor = new ResourceReleaserExecutor(this::reportPossibleLeak);
    private Optional<ModuleLayerInformationSupplier> moduleLayerInformation = Optional.empty();

    public MuleArtifactClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        super(urls, parent, lookupPolicy);
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)artifactId) ? 1 : 0) != 0, (String)"artifactId cannot be empty");
        Preconditions.checkArgument((artifactDescriptor != null ? 1 : 0) != 0, (String)"artifactDescriptor cannot be null");
        this.artifactId = artifactId;
        this.artifactDescriptor = artifactDescriptor;
        this.resourceReleaserExecutor.addResourceReleaser(() -> new ClassLoaderResourceReleaser(this));
        this.resourceReleaserExecutor.addResourceReleaser(() -> new MvelClassLoaderReleaser(this));
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public <T extends ArtifactDescriptor> T getArtifactDescriptor() {
        return (T)this.artifactDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String name) {
        Matcher matcher;
        if (name.startsWith(RESOURCE_PREFIX) && (matcher = GAV_EXTENDED_PATTERN.matcher(name)).matches()) {
            String groupId = matcher.group(1);
            String artifactId = matcher.group(2);
            String version = matcher.group(3);
            String classifier = matcher.group(4);
            String type = matcher.group(5);
            String resource = matcher.group(6);
            LOGGER.debug("Artifact request for '{}' in group '{}', artifact '{}' and version '{}', with classifier '{}' and type '{}'.", new Object[]{resource, groupId, artifactId, version, classifier, type});
            String normalizedResource = FilenameUtils.normalize((String)resource, (boolean)true);
            BundleDescriptor requestDescriptor = new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).setBaseVersion(version).setClassifier(classifier).setType(type).build();
            URLClassLoader classLoader = WILDCARD.equals(version) ? (URLClassLoader)this.descriptorMapping.entrySet().stream().filter(entry -> this.isRequestedArtifact((BundleDescriptor)entry.getKey(), requestDescriptor, () -> false)).map(Map.Entry::getValue).findAny().orElse(null) : this.descriptorMapping.get(requestDescriptor);
            if (classLoader != null) {
                return classLoader.findResource(normalizedResource);
            }
            Optional<URL> match = Arrays.stream(this.getURLs()).filter(url -> {
                String urlPath = url.getPath();
                return urlPath.contains(this.asPath(requestDescriptor)) && urlPath.endsWith(this.asExtension(requestDescriptor));
            }).findFirst();
            if (match.isPresent()) {
                URL url2 = match.get();
                BundleDescriptor matchDescriptor = this.toBundleDescriptor(url2, groupId);
                Object object = this.descriptorMappingLock;
                synchronized (object) {
                    if (this.descriptorMapping.get(matchDescriptor) == null) {
                        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{url2}, MuleArtifactClassLoader.getSystemClassLoader(), CachingURLStreamHandlerFactory.getCachingURLStreamHandlerFactory());
                        this.descriptorMapping.put(matchDescriptor, urlClassLoader);
                    }
                }
                return this.descriptorMapping.get(matchDescriptor).findResource(normalizedResource);
            }
        }
        return super.findResource(name);
    }

    private String asPath(BundleDescriptor descriptor) {
        String groupIdPath = this.getGroupIdPath(descriptor.getGroupId());
        String versionPath = WILDCARD.equals(descriptor.getVersion()) ? "" : descriptor.getVersion();
        return groupIdPath + PATH_SEPARATOR + descriptor.getArtifactId() + PATH_SEPARATOR + versionPath;
    }

    private String asExtension(BundleDescriptor descriptor) {
        return descriptor.getClassifier().orElse("") + "." + descriptor.getType();
    }

    private BundleDescriptor toBundleDescriptor(URL artifactUrl, String groupId) {
        String artifactPath = artifactUrl.getPath();
        String groupIdPath = this.getGroupIdPath(groupId);
        int artifactIdIndex = artifactPath.indexOf(groupIdPath) + groupIdPath.length();
        Matcher urlMatcher = MAVEN_ARTIFACT_PATTERN.matcher(artifactPath.substring(artifactIdIndex));
        urlMatcher.find();
        return new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(urlMatcher.group(1)).setVersion(urlMatcher.group(2)).setBaseVersion(urlMatcher.group(2)).setClassifier(urlMatcher.group(3)).setType(urlMatcher.group(4)).build();
    }

    private String getGroupIdPath(String groupId) {
        return DOT_REPLACEMENT_PATTERN.matcher(groupId).replaceAll(PATH_SEPARATOR);
    }

    boolean isRequestedArtifact(BundleDescriptor descriptor, BundleDescriptor artifact, Supplier<Boolean> onVersionMismatch) {
        return this.isRequestedArtifact(descriptor, artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getClassifier(), artifact.getType(), onVersionMismatch);
    }

    boolean isRequestedArtifact(BundleDescriptor descriptor, String groupId, String artifactId, String version, Optional<String> classifier, String type, Supplier<Boolean> onVersionMismatch) {
        boolean versionResult = true;
        if (!descriptor.getBaseVersion().equals(version) && !WILDCARD.equals(version)) {
            versionResult = onVersionMismatch.get();
        }
        return descriptor.getGroupId().equals(groupId) && descriptor.getArtifactId().equals(artifactId) && versionResult && descriptor.getClassifier().equals(classifier) && descriptor.getType().equals(type);
    }

    @Override
    public URL findInternalResource(String resource) {
        return this.findResource(resource);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = super.loadClass(name, resolve);
        if (!(this.shouldReleaseJdbcReferences || !Driver.class.isAssignableFrom(clazz) || clazz.equals(Driver.class) || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()))) {
            this.shouldReleaseJdbcReferences = true;
        }
        if (!this.shouldReleaseIbmMQResources && name.startsWith("com.ibm.mq")) {
            this.shouldReleaseIbmMQResources = true;
        }
        if (!this.shouldReleaseActiveMQReferences && name.startsWith("org.apache.activemq")) {
            this.shouldReleaseActiveMQReferences = true;
        }
        if (!this.shouldReleaseGroovyReferences && name.startsWith("org.codehaus.groovy")) {
            this.shouldReleaseGroovyReferences = true;
        }
        return clazz;
    }

    @Override
    public Class<?> loadInternalClass(String name) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    protected String[] getLocalResourceLocations() {
        return new String[0];
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.shutdownListeners.add(listener);
    }

    @Override
    public void dispose() {
        this.descriptorMapping.forEach((descriptor, classloader) -> {
            try {
                classloader.close();
            }
            catch (IOException e) {
                this.reportPossibleLeak(e, descriptor.getArtifactId());
            }
        });
        this.descriptorMapping.clear();
        if (IS_JAVA_VERSION_AT_MOST_11) {
            this.addLegacyExtensionsResourceReleasers();
        }
        if (this.shouldReleaseGroovyReferences) {
            this.resourceReleaserExecutor.addResourceReleaser(() -> new GroovyResourceReleaser(this));
        }
        this.resourceReleaserExecutor.executeResourceReleasers();
        super.dispose();
        this.shutdownListeners();
    }

    @Deprecated
    private void addLegacyExtensionsResourceReleasers() {
        this.resourceReleaserExecutor.addResourceReleaser(() -> new AwsIdleConnectionReaperResourceReleaser(this));
        this.resourceReleaserExecutor.addResourceReleaser(ScalaClassValueReleaser::new);
        if (this.shouldReleaseJdbcReferences) {
            this.resourceReleaserExecutor.addResourceReleaser(this::createResourceReleaserInstance);
        }
        if (this.shouldReleaseIbmMQResources) {
            this.resourceReleaserExecutor.addResourceReleaser(() -> new IBMMQResourceReleaser(this));
        }
        if (this.shouldReleaseActiveMQReferences) {
            this.resourceReleaserExecutor.addResourceReleaser(() -> new ActiveMQResourceReleaser(this));
        }
    }

    private void reportPossibleLeak(Throwable t) {
        this.reportPossibleLeak(t, this.artifactId);
    }

    protected void reportPossibleLeak(Throwable t, String artifactId) {
        LOGGER.error(String.format("Error disposing classloader for '%s'. This can cause a memory leak", artifactId), t);
    }

    private void shutdownListeners() {
        for (ShutdownListener listener : this.shutdownListeners) {
            try {
                listener.execute();
            }
            catch (Exception e) {
                LOGGER.error("Error executing shutdown listener", (Throwable)e);
            }
        }
        this.shutdownListeners.clear();
    }

    private <T> T createInstance(String classLocation) {
        try {
            Class clazz = this.createClass(classLocation);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create instance from resource: " + classLocation, e);
        }
    }

    protected ResourceReleaser createResourceReleaserInstance() {
        if (this.jdbcResourceReleaserInstance == null) {
            this.jdbcResourceReleaserInstance = (ResourceReleaser)this.createInstance(this.dbResourceReleaserClassLocation);
        }
        return this.jdbcResourceReleaserInstance;
    }

    public void setResourceReleaserClassLocation(String resourceReleaserClassLocation) {
        this.dbResourceReleaserClassLocation = resourceReleaserClassLocation;
    }

    private Class createClass(String classLocation) {
        Class<?> clazz;
        InputStream classStream = null;
        try {
            classStream = this.getClass().getResourceAsStream(classLocation);
            byte[] classBytes = IOUtils.toByteArray((InputStream)classStream);
            classStream.close();
            clazz = this.defineClass(null, classBytes, 0, classBytes.length);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Can not create class from resource: " + classLocation, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(classStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)classStream);
        return clazz;
    }

    @Override
    public URL findLocalResource(String resourceName) {
        return this.getLocalResourceLocator().findLocalResource(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalResourceLocator getLocalResourceLocator() {
        if (this.localResourceLocator == null) {
            Object object = this.localResourceLocatorLock;
            synchronized (object) {
                if (this.localResourceLocator == null) {
                    this.localResourceLocator = new DirectoryResourceLocator(this.getLocalResourceLocations());
                }
            }
        }
        return this.localResourceLocator;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.getArtifactId(), Integer.toHexString(System.identityHashCode(this)));
    }

    @Override
    public void setModuleLayerInformationSupplier(ModuleLayerInformationSupplier moduleLayerInformationSupplier) {
        this.moduleLayerInformation = Optional.of(moduleLayerInformationSupplier);
    }

    @Override
    public Optional<ModuleLayerInformationSupplier> getModuleLayerInformation() {
        return this.moduleLayerInformation;
    }

    static {
        MuleArtifactClassLoader.registerAsParallelCapable();
        LOGGER = LoggerFactory.getLogger(MuleArtifactClassLoader.class);
        DOT_REPLACEMENT_PATTERN = Pattern.compile("\\.");
        GAV_EXTENDED_PATTERN = Pattern.compile("resource::([^\\*|\\s]+):([^\\*|\\s]+):([^\\s]+):([^\\*|\\s]+)?:([^\\*|\\s]+):([^\\*]+)");
        MAVEN_ARTIFACT_PATTERN = Pattern.compile("/([^\\s]+)/([^\\s]+)/\\1-\\2-?([^\\s]+)?\\.([^\\s]+)");
        IS_JAVA_VERSION_AT_MOST_11 = SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11);
    }
}

