/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.classloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;

public class ResourceReleaserExecutor {
    private final Collection<Supplier<ResourceReleaser>> resourceReleaserSuppliers = new ArrayList<Supplier<ResourceReleaser>>();
    private final Consumer<Throwable> onError;

    public ResourceReleaserExecutor(Consumer<Throwable> onError) {
        this.onError = onError;
    }

    public void addResourceReleaser(Supplier<ResourceReleaser> resourceReleaserSupplier) {
        this.resourceReleaserSuppliers.add(resourceReleaserSupplier);
    }

    public void executeResourceReleasers() {
        for (Supplier<ResourceReleaser> resourceReleaserSupplier : this.resourceReleaserSuppliers) {
            try {
                resourceReleaserSupplier.get().release();
            }
            catch (Throwable t) {
                this.onError.accept(t);
            }
        }
    }
}

