/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GroovyResourceReleaser
implements ResourceReleaser {
    private final ClassLoader classLoader;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyResourceReleaser.class);
    private static final String GROOVY_CLASS_INFO = "org.codehaus.groovy.reflection.ClassInfo";
    private static final String GROOVY_INVOKER_HELPER = "org.codehaus.groovy.runtime.InvokerHelper";
    private static final String GROOVY_SCRIPT_ENGINE_FACTORY = "org.codehaus.groovy.jsr223.GroovyScriptEngineFactory";
    private static final String LOGGER_ABSTRACT_MANAGER = "org.apache.logging.log4j.core.appender.AbstractManager";
    private static final String LOGGER_STREAM_MANAGER = "org.apache.logging.log4j.core.appender.OutputStreamManager";
    private static final String LOGGER_CONFIGURATION = "org.apache.logging.log4j.core.config.Configuration";

    public GroovyResourceReleaser(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void release() {
        this.unregisterAllClassesFromInvokerHelper();
        this.cleanSpisEngines();
    }

    private void unregisterAllClassesFromInvokerHelper() {
        try {
            Class<?> classInfoClass = this.classLoader.loadClass(GROOVY_CLASS_INFO);
            Method getAllClassInfoMethod = classInfoClass.getMethod("getAllClassInfo", new Class[0]);
            Method getTheClassMethod = classInfoClass.getMethod("getTheClass", new Class[0]);
            Class<?> invokerHelperClass = this.classLoader.loadClass(GROOVY_INVOKER_HELPER);
            Method removeClassMethod = invokerHelperClass.getMethod("removeClass", Class.class);
            Object classInfos = getAllClassInfoMethod.invoke(null, new Object[0]);
            if (classInfos instanceof Collection) {
                this.unregisterClassesFromInvokerHelper(removeClassMethod, getTheClassMethod, (Collection)classInfos);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Error trying to remove the Groovy's InvokerHelper classes", (Throwable)e);
        }
    }

    private void unregisterClassesFromInvokerHelper(Method removeClassMethod, Method getTheClassMethod, Collection<?> classes) {
        for (Object classInfo : classes) {
            Object clazz = null;
            try {
                clazz = getTheClassMethod.invoke(classInfo, new Object[0]);
                removeClassMethod.invoke(null, clazz);
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                String className = clazz instanceof Class ? ((Class)clazz).getName() : "Unknown";
                LOGGER.warn("Could not remove the {} class from the Groovy's InvokerHelper", (Object)className, (Object)e);
            }
        }
    }

    private void cleanSpisEngines() {
        try {
            Class abstractManager = ClassUtils.loadClass((String)LOGGER_ABSTRACT_MANAGER, (ClassLoader)this.classLoader);
            Map hashMap = (Map)ClassUtils.getStaticFieldValue((Class)abstractManager, (String)"MAP", (boolean)true);
            Class streamManagerClass = ClassUtils.loadClass((String)LOGGER_STREAM_MANAGER, (ClassLoader)this.classLoader);
            for (Object manager : hashMap.values()) {
                if (!streamManagerClass.isInstance(manager)) continue;
                Object rfmInstance = manager;
                Object layout = ClassUtils.getFieldValue(rfmInstance, (String)"layout", (boolean)true);
                Object configuration = ClassUtils.getFieldValue((Object)layout, (String)"configuration", (boolean)true);
                Class configurationClass = ClassUtils.loadClass((String)LOGGER_CONFIGURATION, (ClassLoader)this.classLoader);
                Method getScriptManagerMethod = configurationClass.getMethod("getScriptManager", new Class[0]);
                Object scriptManager = getScriptManagerMethod.invoke(configuration, new Object[0]);
                if (scriptManager == null) continue;
                this.cleanGroovyEngines(scriptManager);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Error trying to unregister the Groovy's Scripting Engine", (Throwable)e);
        }
    }

    private void cleanGroovyEngines(Object scriptManager) throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        Object manager = ClassUtils.getFieldValue((Object)scriptManager, (String)"manager", (boolean)true);
        Iterable engineSpis = (Iterable)ClassUtils.getFieldValue((Object)manager, (String)"engineSpis", (boolean)true);
        Class groovy = ClassUtils.loadClass((String)GROOVY_SCRIPT_ENGINE_FACTORY, (ClassLoader)this.classLoader);
        Iterator engineSpisIterator = engineSpis.iterator();
        while (engineSpisIterator.hasNext()) {
            Object engine = engineSpisIterator.next();
            if (!this.isGroovyScriptEngine(groovy, engine)) continue;
            engineSpisIterator.remove();
        }
    }

    private boolean isGroovyScriptEngine(Class<?> groovy, Object engine) {
        return groovy.isInstance(engine) && engine.getClass().getClassLoader().equals(groovy.getClassLoader());
    }
}

