/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.mule.module.artifact.classloader.MuleSoftReferenceBusterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadGroupContextClassLoaderSoftReferenceBuster {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadGroupContextClassLoaderSoftReferenceBuster.class);
    private static final String VALUE_FIELD = "value";
    private static final String TABLE_FIELD = "table";
    private static final String BEANS_WEAK_IDENTITY_MAP_CLASS = "java.beans.WeakIdentityMap";
    private static final String CLEAR_BEAN_INFO_CACHE_METHOD = "clearBeanInfoCache";
    private static final String THREAD_GROUP_CONTEXT_FIELD = "contexts";
    private static final String THREAD_GROUP_CONTEXT_CLASS = "java.beans.ThreadGroupContext";

    public static void bustSoftReferences(ClassLoader classloader) throws MuleSoftReferenceBusterException {
        Class<?> threadGroupClass = ThreadGroupContextClassLoaderSoftReferenceBuster.getClass(THREAD_GROUP_CONTEXT_CLASS);
        if (threadGroupClass != null) {
            try {
                Field tableField;
                Object contexts = ThreadGroupContextClassLoaderSoftReferenceBuster.readStaticField(threadGroupClass, THREAD_GROUP_CONTEXT_FIELD, true);
                if (contexts != null && (tableField = ThreadGroupContextClassLoaderSoftReferenceBuster.getTableField()) != null) {
                    WeakReference[] table = (WeakReference[])ThreadGroupContextClassLoaderSoftReferenceBuster.getFieldValue(tableField, contexts);
                    ThreadGroupContextClassLoaderSoftReferenceBuster.clearContextGroupTable(table);
                }
            }
            catch (Exception e) {
                throw new MuleSoftReferenceBusterException(classloader, e);
            }
        }
    }

    private static void clearContextGroupTable(WeakReference[] table) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (table != null) {
            Method clearBeanInfoCache = null;
            for (WeakReference entry : table) {
                if (entry == null) continue;
                clearBeanInfoCache = ThreadGroupContextClassLoaderSoftReferenceBuster.clearContext(clearBeanInfoCache, entry);
            }
        }
    }

    private static Method clearContext(Method clearBeanInfoCache, WeakReference entry) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object context = ThreadGroupContextClassLoaderSoftReferenceBuster.getFieldValue(entry, VALUE_FIELD);
        if (context != null) {
            if (clearBeanInfoCache == null) {
                clearBeanInfoCache = ThreadGroupContextClassLoaderSoftReferenceBuster.getMethod(context.getClass(), CLEAR_BEAN_INFO_CACHE_METHOD);
            }
            clearBeanInfoCache.setAccessible(true);
            clearBeanInfoCache.invoke(context, new Object[0]);
        }
        return clearBeanInfoCache;
    }

    private static Field getTableField() {
        return ThreadGroupContextClassLoaderSoftReferenceBuster.getField(ThreadGroupContextClassLoaderSoftReferenceBuster.getClass(BEANS_WEAK_IDENTITY_MAP_CLASS), TABLE_FIELD, true);
    }

    private static Class<?> getClass(String className) {
        Class<?> threadGroupClass = null;
        try {
            threadGroupClass = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            LOGGER.debug(String.format("Class {} was not found while cleaning ThreadGroupContext on undeployment", className));
        }
        return threadGroupClass;
    }

    private static <T> T getFieldValue(Object obj, String fieldName) throws IllegalArgumentException, IllegalAccessException {
        Field field = ThreadGroupContextClassLoaderSoftReferenceBuster.getField(obj.getClass(), fieldName, true);
        return ThreadGroupContextClassLoaderSoftReferenceBuster.getFieldValue(field, obj);
    }

    private static <T> T getFieldValue(Field field, Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (T)field.get(obj);
    }

    private static Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException, SecurityException {
        return clazz.getDeclaredMethod(methodName, new Class[0]);
    }

    public static Object readStaticField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Field field = ThreadGroupContextClassLoaderSoftReferenceBuster.getField(cls, fieldName, forceAccess);
        return ThreadGroupContextClassLoaderSoftReferenceBuster.readStaticField(field, false);
    }

    public static Object readStaticField(Field field, boolean forceAccess) throws IllegalAccessException {
        return ThreadGroupContextClassLoaderSoftReferenceBuster.readField(field, null, forceAccess);
    }

    public static Object readField(Field field, Object target, boolean forceAccess) throws IllegalAccessException {
        if (forceAccess && !field.isAccessible()) {
            field.setAccessible(true);
        }
        return field.get(target);
    }

    public static Field getField(Class<?> cls, String fieldName, boolean forceAccess) {
        for (Class<?> acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field = acls.getDeclaredField(fieldName);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!forceAccess) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        Field match = null;
        for (Class<?> class1 : ThreadGroupContextClassLoaderSoftReferenceBuster.getAllInterfaces(cls)) {
            try {
                Field test;
                match = test = class1.getField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return match;
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ThreadGroupContextClassLoaderSoftReferenceBuster.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!interfacesFound.add(i)) continue;
                ThreadGroupContextClassLoaderSoftReferenceBuster.getAllInterfaces(i, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }
}

