/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.serializer;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;

@NoInstantiate
public final class ArtifactClassLoaderObjectOutputStream
extends ObjectOutputStream {
    private final ClassLoaderRepository classLoaderRepository;

    public ArtifactClassLoaderObjectOutputStream(ClassLoaderRepository classLoaderRepository, OutputStream out) throws IOException {
        super(out);
        this.classLoaderRepository = classLoaderRepository;
        this.enableReplaceObject(true);
    }

    @Override
    protected void annotateClass(Class<?> clazz) throws IOException {
        Optional<String> id = this.classLoaderRepository.getId(clazz.getClassLoader());
        if (id.isPresent()) {
            this.writeInt(id.get().length());
            this.writeBytes(id.get());
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        Throwable throwable;
        if (obj instanceof Throwable && (throwable = (Throwable)obj).getClass().getName().startsWith("io.netty")) {
            RuntimeException replacement = new RuntimeException(throwable.getClass().getName() + ": " + throwable.getMessage(), throwable.getCause());
            replacement.setStackTrace(throwable.getStackTrace());
            return replacement;
        }
        return obj;
    }
}

