/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.util;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.config.FeatureContext;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlaggingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureFlaggingUtils.class);
    private static final LoadingCache<ArtifactDescriptor, FeatureFlaggingService> featureFlags = Caffeine.newBuilder().weakKeys().build(FeatureFlaggingUtils::buildFeatureFlaggingService);

    private FeatureFlaggingUtils() {
    }

    public static boolean isFeatureEnabled(Feature feature, ArtifactDescriptor artifactDescriptor) {
        return Objects.requireNonNull((FeatureFlaggingService)featureFlags.get((Object)artifactDescriptor)).isEnabled(feature);
    }

    private static FeatureFlaggingService buildFeatureFlaggingService(ArtifactDescriptor artifactDescriptor) {
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        LOGGER.debug("Configuring feature flags for artifact [{}]", (Object)artifactDescriptor.getName());
        FeatureContext featureContext = new FeatureContext(artifactDescriptor.getMinMuleVersion(), artifactDescriptor.getName());
        FeatureFlaggingRegistry.getInstance().getFeatureFlagConfigurations().forEach((feature, featureContextPredicate) -> features.put(feature.name(), FeatureFlaggingUtils.evaluateFeatureFlag(feature, featureContext)));
        return new DeploymentFeatureFlaggingService(features);
    }

    private static boolean evaluateFeatureFlag(Feature feature, FeatureContext featureContext) {
        boolean enabled;
        Optional systemPropertyName = feature.getOverridingSystemPropertyName();
        if (systemPropertyName.isPresent() && System.getProperty((String)systemPropertyName.get()) != null) {
            enabled = Boolean.getBoolean((String)systemPropertyName.get());
            LOGGER.debug("Setting feature {} = {} for artifact [{}] because of System Property '{}'", new Object[]{feature, enabled, featureContext.getArtifactName(), systemPropertyName});
        } else {
            enabled = ((Predicate)FeatureFlaggingRegistry.getInstance().getFeatureFlagConfigurations().get(feature)).test(featureContext);
            LOGGER.debug("Setting feature {} = {} for artifact [{}]", new Object[]{feature, enabled, featureContext.getArtifactName()});
        }
        return enabled;
    }

    private static class DeploymentFeatureFlaggingService
    implements FeatureFlaggingService {
        private final Map<String, Boolean> featureFlags;

        public DeploymentFeatureFlaggingService(Map<String, Boolean> featureFlags) {
            this.featureFlags = featureFlags;
        }

        public boolean isEnabled(Feature feature) {
            if (!this.featureFlags.containsKey(feature.name())) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Feature %s not registered", (Object[])new Object[]{feature}));
            }
            return this.featureFlags.get(feature.name());
        }
    }
}

