/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicyProvider;
import org.mule.runtime.module.artifact.api.classloader.DisposableClassLoader;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.exception.CompositeClassNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.CompoundEnumeration;

@NoInstantiate
public class FineGrainedControlClassLoader
extends URLClassLoader
implements DisposableClassLoader,
ClassLoaderLookupPolicyProvider {
    private static final Logger LOGGER;
    private final ClassLoaderLookupPolicy lookupPolicy;
    private final boolean verboseLogging;

    public FineGrainedControlClassLoader(URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        super(urls, parent);
        Preconditions.checkArgument((lookupPolicy != null ? 1 : 0) != 0, (String)"Lookup policy cannot be null");
        this.lookupPolicy = lookupPolicy;
        this.verboseLogging = LOGGER.isDebugEnabled() || this.isVerboseLoggingEnabled();
    }

    private boolean isVerboseLoggingEnabled() {
        return LOGGER.isInfoEnabled() && Boolean.valueOf(System.getProperty("mule.classloading.verbose")) != false;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        LookupStrategy lookupStrategy = this.lookupPolicy.getClassLookupStrategy(name);
        if (lookupStrategy == null) {
            throw new NullPointerException(String.format("Unable to find a lookup strategy for '%s' from %s", name, this));
        }
        if (this.verboseLogging) {
            this.logLoadingClass(name, lookupStrategy, "Loading class '%s' with '%s' on '%s'", this);
        }
        ArrayList<ClassNotFoundException> exceptions = new ArrayList<ClassNotFoundException>();
        for (ClassLoader classLoader : lookupStrategy.getClassLoaders(this)) {
            try {
                if (classLoader == this) {
                    result = this.findLocalClass(name);
                    break;
                }
                result = this.findParentClass(name, classLoader);
                break;
            }
            catch (ClassNotFoundException e) {
                exceptions.add(e);
            }
        }
        if (result == null) {
            throw new CompositeClassNotFoundException(name, lookupStrategy, exceptions);
        }
        if (this.verboseLogging) {
            this.logLoadedClass(name, result);
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    private void logLoadingClass(String name, LookupStrategy lookupStrategy, String format, FineGrainedControlClassLoader fineGrainedControlClassLoader) {
        String message = String.format(format, name, lookupStrategy, fineGrainedControlClassLoader);
        this.doVerboseLogging(message);
    }

    private void logLoadedClass(String name, Class<?> result) {
        boolean loadedFromChild = result.getClassLoader() == this;
        String message = String.format("Loaded class '%s' from %s: %s", name, loadedFromChild ? "child" : "parent", loadedFromChild ? this : this.getParent());
        this.doVerboseLogging(message);
    }

    private void doVerboseLogging(String message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message);
        } else {
            LOGGER.info(message);
        }
    }

    protected Class<?> findParentClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader != null) {
            return classLoader.loadClass(name);
        }
        return this.findSystemClass(name);
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.getParent() != null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[2];
        tmp[0] = this.findResources(name);
        if (this.getParent() != null) {
            tmp[1] = this.getParent().getResources(name);
        }
        return new CompoundEnumeration(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> findLocalClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> result = this.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            return super.findClass(name);
        }
    }

    @Override
    public ClassLoaderLookupPolicy getClassLoaderLookupPolicy() {
        return this.lookupPolicy;
    }

    @Override
    public void dispose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Class clazz = ClassUtils.loadClass((String)"org.codehaus.groovy.transform.ASTTransformationVisitor", this.getClass());
            Field compUnit = clazz.getDeclaredField("compUnit");
            compUnit.setAccessible(true);
            compUnit.set(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        FineGrainedControlClassLoader.registerAsParallelCapable();
        LOGGER = LoggerFactory.getLogger(FineGrainedControlClassLoader.class);
    }
}

