/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.module.artifact.internal.util.JarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;

public class FileJarExplorer
implements JarExplorer {
    protected static final String CLASS_EXTENSION = ".class";

    @Override
    public JarInfo explore(URI library) {
        HashSet<String> resources;
        HashSet<String> packages;
        block23: {
            packages = new HashSet<String>();
            resources = new HashSet<String>();
            try {
                File libraryFile = new File(library);
                if (!libraryFile.exists()) {
                    throw new IllegalArgumentException("Library file does not exists: " + library);
                }
                if (libraryFile.isDirectory()) {
                    Collection files = FileUtils.listFiles((File)libraryFile, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.INSTANCE);
                    for (File classFile : files) {
                        String relativePath = classFile.getAbsolutePath().substring(libraryFile.getAbsolutePath().length() + 1);
                        if (relativePath.endsWith(CLASS_EXTENSION)) {
                            String packageName = ClassUtils.getPackageName((String)relativePath.substring(0, relativePath.length() - CLASS_EXTENSION.length()).replace(File.separator, "."));
                            packages.add(packageName);
                            continue;
                        }
                        if (File.separatorChar == '/') {
                            resources.add(relativePath);
                            continue;
                        }
                        resources.add(relativePath.replace(File.separator, "/"));
                    }
                    break block23;
                }
                if (!libraryFile.getName().toLowerCase().endsWith(".jar")) break block23;
                try (ZipInputStream zip = new ZipInputStream(new FileInputStream(libraryFile));){
                    ZipEntry entry = zip.getNextEntry();
                    while (entry != null) {
                        if (!entry.isDirectory()) {
                            if (entry.getName().endsWith(CLASS_EXTENSION)) {
                                String packageName = ClassUtils.getPackageName((String)entry.getName().substring(0, entry.getName().length() - CLASS_EXTENSION.length()).replace("/", "."));
                                packages.add(packageName);
                            } else {
                                resources.add(entry.getName());
                            }
                        }
                        entry = zip.getNextEntry();
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot explore URL: " + library, e);
            }
        }
        return new JarInfo(packages, resources);
    }
}

