/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.serializer;

import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.internal.serialization.JavaExternalSerializerProtocol;
import org.mule.runtime.module.artifact.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.serializer.protocol.CustomJavaSerializationProtocol;

public class ArtifactObjectSerializer
implements ObjectSerializer,
MuleContextAware {
    private volatile JavaExternalSerializerProtocol javaExternalSerializerProtocol;
    private volatile CustomJavaSerializationProtocol javaInternalSerializerProtocol;

    public ArtifactObjectSerializer(ClassLoaderRepository classLoaderRepository) {
        Preconditions.checkArgument((classLoaderRepository != null ? 1 : 0) != 0, (String)"ClassLoaderRepository cannot be null");
        this.javaExternalSerializerProtocol = new JavaExternalSerializerProtocol();
        this.javaInternalSerializerProtocol = new CustomJavaSerializationProtocol(classLoaderRepository);
    }

    public SerializationProtocol getInternalProtocol() {
        return this.javaInternalSerializerProtocol;
    }

    public SerializationProtocol getExternalProtocol() {
        return this.javaExternalSerializerProtocol;
    }

    public void setMuleContext(MuleContext context) {
        this.javaInternalSerializerProtocol.setMuleContext(context);
        this.javaExternalSerializerProtocol.setMuleContext(context);
    }
}

