/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.Classifier;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.module.artifact.activation.internal.maven.MavenUtilsForArtifact;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;

public class AdditionalPluginDependenciesResolver {
    protected static final String MULE_APPLICATION_CLASSIFIER = "mule-application";
    private final File temporaryFolder;
    private final Map<ArtifactCoordinates, Supplier<MavenPomModel>> pomModels;
    private final MavenClient mavenClient;
    private final Map<String, List<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> pluginsWithAdditionalDependencies;

    public AdditionalPluginDependenciesResolver(MavenClient muleMavenPluginClient, List<AdditionalPluginDependencies> additionalPluginDependencies, File temporaryFolder) {
        this(muleMavenPluginClient, additionalPluginDependencies, temporaryFolder, Collections.emptyMap());
    }

    public AdditionalPluginDependenciesResolver(MavenClient muleMavenPluginClient, List<AdditionalPluginDependencies> additionalPluginDependencies, File temporaryFolder, Map<ArtifactCoordinates, Supplier<MavenPomModel>> pomModels) {
        this.mavenClient = muleMavenPluginClient;
        this.pluginsWithAdditionalDependencies = additionalPluginDependencies.stream().collect(Collectors.toMap(apd -> apd.getGroupId() + ":" + apd.getArtifactId(), apd -> apd.getAdditionalDependencies().stream().map(MavenUtilsForArtifact::mavenToArtifact).collect(Collectors.toList())));
        this.temporaryFolder = temporaryFolder;
        this.pomModels = pomModels;
    }

    public Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> applicationDependencies, Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<BundleDependency>> pluginsDependencies) {
        this.addPluginDependenciesAdditionalLibraries(applicationDependencies);
        LinkedHashMap<BundleDependency, List<BundleDependency>> pluginsWithAdditionalDeps = new LinkedHashMap<BundleDependency, List<BundleDependency>>();
        this.pluginsWithAdditionalDependencies.forEach((k, v) -> {
            BundleDependency pluginBundleDependency = this.getPluginBundleDependency((String)k, applicationDependencies);
            List<BundleDependency> pluginDependencies = this.getPluginDependencies((String)k, pluginsDependencies);
            List<org.mule.maven.pom.parser.api.model.BundleDependency> additionalDependencies = this.resolveDependencies(v.stream().filter(additionalDep -> pluginDependencies.stream().noneMatch(artifactDependency -> this.areSameArtifact((org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)additionalDep, (BundleDependency)artifactDependency))).collect(Collectors.toList()));
            if (!additionalDependencies.isEmpty()) {
                pluginsWithAdditionalDeps.put(pluginBundleDependency, additionalDependencies.stream().map(MavenUtilsForArtifact::mavenToArtifact).collect(Collectors.toList()));
            }
        });
        return pluginsWithAdditionalDeps;
    }

    private List<org.mule.maven.pom.parser.api.model.BundleDependency> resolveDependencies(List<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> additionalDependencies) {
        return this.mavenClient.resolveArtifactDependencies(additionalDependencies.stream().map(MavenUtilsForArtifact::artifactToMaven).collect(Collectors.toList()), Optional.of(this.mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation()), Optional.empty());
    }

    private BundleDependency getPluginBundleDependency(String pluginCoordinates, List<BundleDependency> mulePlugins) {
        return mulePlugins.stream().filter(mulePlugin -> StringUtils.equals((CharSequence)(mulePlugin.getDescriptor().getGroupId() + ":" + mulePlugin.getDescriptor().getArtifactId()), (CharSequence)pluginCoordinates)).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Declared additional dependencies for a plugin not present: " + pluginCoordinates))));
    }

    private List<BundleDependency> getPluginDependencies(String pluginCoordinates, Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<BundleDependency>> pluginsDependencies) {
        return pluginsDependencies.entrySet().stream().filter(pluginDependenciesEntry -> StringUtils.equals((CharSequence)(((org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginDependenciesEntry.getKey()).getGroupId() + ":" + ((org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginDependenciesEntry.getKey()).getArtifactId()), (CharSequence)pluginCoordinates)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not find dependencies for plugin: " + pluginCoordinates))));
    }

    private boolean areSameArtifact(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor dependency, BundleDependency artifact) {
        return StringUtils.equals((CharSequence)dependency.getArtifactId(), (CharSequence)artifact.getDescriptor().getArtifactId()) && StringUtils.equals((CharSequence)dependency.getGroupId(), (CharSequence)artifact.getDescriptor().getGroupId()) && StringUtils.equals((CharSequence)dependency.getVersion(), (CharSequence)artifact.getDescriptor().getVersion());
    }

    private void addPluginDependenciesAdditionalLibraries(List<BundleDependency> applicationDependencies) {
        List<BundleDependency> mulePlugins = applicationDependencies.stream().filter(bundleDependency -> Classifier.MULE_PLUGIN.equals((String)bundleDependency.getDescriptor().getClassifier().orElse(null))).collect(Collectors.toList());
        Collection<AdditionalPluginDependencies> additionalDependenciesFromMulePlugins = this.resolveAdditionalDependenciesFromMulePlugins(mulePlugins);
        this.pluginsWithAdditionalDependencies.putAll(additionalDependenciesFromMulePlugins.stream().filter(this.isNotRedefinedAtApplicationLevel()).collect(Collectors.toMap(apd -> apd.getGroupId() + ":" + apd.getArtifactId(), apd -> apd.getAdditionalDependencies().stream().map(MavenUtilsForArtifact::mavenToArtifact).collect(Collectors.toList()))));
    }

    private Collection<AdditionalPluginDependencies> resolveAdditionalDependenciesFromMulePlugins(List<BundleDependency> mulePlugins) {
        HashMap additionalDependenciesFromMulePlugins = new HashMap();
        mulePlugins.stream().filter(mulePlugin -> {
            Supplier<MavenPomModel> modelSupplier = this.pomModels.get(this.getArtifactCoordinates((BundleDependency)mulePlugin));
            if (modelSupplier != null) {
                return modelSupplier.get().getPackaging().equals(MULE_APPLICATION_CLASSIFIER);
            }
            return this.mavenClient.getRawPomModel(new File(mulePlugin.getBundleUri())).getPackaging().equals(MULE_APPLICATION_CLASSIFIER);
        }).forEach(mulePlugin -> {
            Supplier<MavenPomModel> pomModel = this.pomModels.getOrDefault(this.getArtifactCoordinates((BundleDependency)mulePlugin), () -> this.mavenClient.getEffectiveModel(new File(mulePlugin.getBundleUri()), Optional.of(this.temporaryFolder)));
            MavenPomParser mavenPomParser = MavenPomParserProvider.discoverProvider().createMavenPomParserClient(((File)pomModel.get().getPomFile().get()).toPath());
            mavenPomParser.getPomAdditionalPluginDependenciesForArtifacts().values().forEach(mavenPlugin -> {
                String artifact = mavenPlugin.getGroupId() + ":" + mavenPlugin.getArtifactId();
                AdditionalPluginDependencies alreadyDefinedPluginAdditionalDependencies = (AdditionalPluginDependencies)additionalDependenciesFromMulePlugins.get(artifact);
                if (alreadyDefinedPluginAdditionalDependencies != null) {
                    LinkedList effectiveDependencies = new LinkedList(alreadyDefinedPluginAdditionalDependencies.getAdditionalDependencies());
                    mavenPlugin.getAdditionalDependencies().forEach(additionalDependenciesDependency -> {
                        boolean addDependency = true;
                        for (int i = 0; i < effectiveDependencies.size(); ++i) {
                            BundleDescriptor effectiveDependency = (BundleDescriptor)effectiveDependencies.get(i);
                            if (!effectiveDependency.getGroupId().equals(additionalDependenciesDependency.getGroupId()) || !effectiveDependency.getArtifactId().equals(additionalDependenciesDependency.getArtifactId()) || !effectiveDependency.getType().equals(additionalDependenciesDependency.getType()) || !effectiveDependency.getClassifier().equals(additionalDependenciesDependency.getClassifier())) continue;
                            if (this.isNewerVersion(additionalDependenciesDependency.getVersion(), effectiveDependency.getVersion())) {
                                effectiveDependencies.remove(i);
                                break;
                            }
                            addDependency = false;
                            break;
                        }
                        if (addDependency) {
                            effectiveDependencies.add(additionalDependenciesDependency);
                        }
                    });
                    AdditionalPluginDependencies alreadyDefinedEffectivePluginAdditionalDependencies = new AdditionalPluginDependencies(alreadyDefinedPluginAdditionalDependencies, effectiveDependencies);
                    additionalDependenciesFromMulePlugins.replace(artifact, alreadyDefinedEffectivePluginAdditionalDependencies);
                } else {
                    additionalDependenciesFromMulePlugins.put(mavenPlugin.getGroupId() + ":" + mavenPlugin.getArtifactId(), mavenPlugin);
                }
            });
        });
        return additionalDependenciesFromMulePlugins.values();
    }

    private boolean isNewerVersion(String dependencyA, String dependencyB) {
        try {
            return new Semver(dependencyA, Semver.SemverType.LOOSE).isGreaterThan(new Semver(dependencyB, Semver.SemverType.LOOSE));
        }
        catch (IllegalArgumentException e) {
            return dependencyA.compareTo(dependencyB) > 0;
        }
    }

    private ArtifactCoordinates getArtifactCoordinates(BundleDependency mulePlugin) {
        return mulePlugin.getDescriptor();
    }

    private Predicate<AdditionalPluginDependencies> isNotRedefinedAtApplicationLevel() {
        return dependencyPluginAdditionalDependencies -> !this.pluginsWithAdditionalDependencies.entrySet().stream().anyMatch(pluginWithAdditionalDependenciesEntry -> ((String)pluginWithAdditionalDependenciesEntry.getKey()).equals(dependencyPluginAdditionalDependencies.getGroupId() + ":" + dependencyPluginAdditionalDependencies.getArtifactId()));
    }
}

