/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader;

public enum Classifier {
    MULE_APPLICATION("mule-application"),
    MULE_DOMAIN("mule-domain"),
    MULE_PLUGIN("mule-plugin");

    private final String name;

    public static Classifier fromString(String name) {
        for (Classifier classifier : Classifier.values()) {
            if (!classifier.name.equals(name)) continue;
            return classifier;
        }
        throw new IllegalArgumentException("No Classifier with name '" + name + "'." + name);
    }

    private Classifier(String name) {
        this.name = name;
    }

    public boolean equals(String name) {
        Classifier other;
        if (name == null) {
            return false;
        }
        try {
            other = Classifier.fromString(name);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return other != null && other.equals((Object)this);
    }

    public String toString() {
        return this.name;
    }
}

