/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.extension.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;

public class DefaultExtensionDiscoveryRequest
implements ExtensionDiscoveryRequest {
    private final Collection<ArtifactPluginDescriptor> artifactPlugins;
    private final Set<ExtensionModel> parentArtifactExtensions;
    private final boolean parallelDiscovery;
    private final boolean enrichDescriptions;
    private final boolean ocsEnabled;
    private final boolean forceExtensionValidation;
    private final boolean resolveMinMuleVersion;
    private final Map<String, Object> customParameters;

    public DefaultExtensionDiscoveryRequest(Collection<ArtifactPluginDescriptor> artifactPlugins, Set<ExtensionModel> parentArtifactExtensions, boolean parallelDiscovery, boolean enrichDescriptions, boolean resolveMinMuleVersion) {
        this(artifactPlugins, parentArtifactExtensions, parallelDiscovery, enrichDescriptions, false, false, resolveMinMuleVersion, Collections.emptyMap());
    }

    public DefaultExtensionDiscoveryRequest(Collection<ArtifactPluginDescriptor> artifactPlugins, Set<ExtensionModel> parentArtifactExtensions, boolean parallelDiscovery, boolean enrichDescriptions, boolean ocsEnabled, boolean forceExtensionValidation, boolean resolveMinMuleVersion, Map<String, Object> customParameters) {
        this.artifactPlugins = artifactPlugins;
        this.parentArtifactExtensions = parentArtifactExtensions;
        this.parallelDiscovery = parallelDiscovery;
        this.enrichDescriptions = enrichDescriptions;
        this.ocsEnabled = ocsEnabled;
        this.forceExtensionValidation = forceExtensionValidation;
        this.resolveMinMuleVersion = resolveMinMuleVersion;
        this.customParameters = Collections.unmodifiableMap(customParameters);
    }

    @Override
    public <T> Optional<T> getParameter(String key) {
        return Optional.ofNullable(this.customParameters.get(key));
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.customParameters;
    }

    @Override
    public Collection<ArtifactPluginDescriptor> getArtifactPluginDescriptors() {
        return this.artifactPlugins;
    }

    @Override
    public Set<ExtensionModel> getParentArtifactExtensions() {
        return this.parentArtifactExtensions;
    }

    @Override
    public boolean isParallelDiscovery() {
        return this.parallelDiscovery;
    }

    @Override
    public boolean isEnrichDescriptions() {
        return this.enrichDescriptions;
    }

    @Override
    public boolean isOCSEnabled() {
        return this.ocsEnabled;
    }

    @Override
    public boolean isForceExtensionValidation() {
        return this.forceExtensionValidation;
    }

    @Override
    public boolean isResolveMinMuleVersion() {
        return this.resolveMinMuleVersion;
    }
}

