/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.internal.maven.AbstractMavenDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class LightweightDeployableProjectModelBuilder
extends AbstractMavenDeployableProjectModelBuilder {
    private final boolean isDomain;
    private final Optional<MuleDeployableModel> model;

    public LightweightDeployableProjectModelBuilder(File projectFolder, boolean isDomain) {
        this(projectFolder, Optional.empty(), isDomain);
    }

    public LightweightDeployableProjectModelBuilder(File projectFolder, Optional<MuleDeployableModel> model, boolean isDomain) {
        super(GlobalConfigLoader.getMavenConfig(), projectFolder);
        this.model = model;
        this.isDomain = isDomain;
    }

    @Override
    protected DeployableProjectModel doBuild(MavenPomParser parser, ArtifactCoordinates deployableArtifactCoordinates) {
        Supplier<MuleDeployableModel> deployableModelResolver = this.getDeployableModelResolver();
        MuleDeployableModel deployableModel = deployableModelResolver.get();
        List<String> exportedPackages = this.getAttribute(deployableModel.getClassLoaderModelLoaderDescriptor().getAttributes(), "exportedPackages");
        List<String> exportedResources = this.getAttribute(deployableModel.getClassLoaderModelLoaderDescriptor().getAttributes(), "exportedResources");
        return new DeployableProjectModel(exportedPackages, exportedResources, Collections.emptyList(), this.buildBundleDescriptor(deployableArtifactCoordinates, this.isDomain), deployableModelResolver, this.projectFolder, this.deployableBundleDependencies, this.sharedDeployableBundleDescriptors, this.additionalPluginDependencies);
    }

    @Override
    protected File getPomFromFolder(File projectFolder) {
        File file;
        block9: {
            File mavenFolder = new File(projectFolder, "META-INF/maven");
            Stream<Path> stream = Files.find(mavenFolder.toPath(), 3, (p, m) -> p.getFileName().toString().equals("pom.xml"), new FileVisitOption[0]);
            try {
                List pomLists = stream.collect(Collectors.toList());
                if (pomLists.size() != 1) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could find the pom in " + mavenFolder.toPath())));
                }
                file = ((Path)pomLists.get(0)).toFile();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
            stream.close();
        }
        return file;
    }

    @Override
    protected boolean isIncludeTestDependencies() {
        return Boolean.parseBoolean(this.getSimpleAttribute(this.getDeployableModelResolver().get().getClassLoaderModelLoaderDescriptor().getAttributes(), "includeTestDependencies", "false"));
    }

    private Supplier<MuleDeployableModel> getDeployableModelResolver() {
        return () -> this.model.orElseGet(() -> {
            if (this.isDomain) {
                return ArtifactModelResolver.domainModelResolver().resolve(new File(this.projectFolder, "META-INF/mule-artifact"));
            }
            return ArtifactModelResolver.applicationModelResolver().resolve(new File(this.projectFolder, "META-INF/mule-artifact"));
        });
    }

    private BundleDescriptor buildBundleDescriptor(ArtifactCoordinates artifactCoordinates, boolean isDomain) {
        return new BundleDescriptor.Builder().setArtifactId(artifactCoordinates.getArtifactId()).setGroupId(artifactCoordinates.getGroupId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setType(artifactCoordinates.getType()).setClassifier(isDomain ? "mule-domain" : "mule-application").build();
    }
}

