/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.maven.client.internal.util.MavenUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.ArtifactUtils;
import org.mule.runtime.module.artifact.activation.internal.deployable.AbstractDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.deployable.DeployablePluginsDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.AdditionalPluginDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.DeployableDependencyResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.MavenDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.plugin.Plugin;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tools.api.classloader.model.ApplicationGAVModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public abstract class AbstractMavenDeployableProjectModelBuilder
extends AbstractDeployableProjectModelBuilder {
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    protected final MavenConfiguration mavenConfiguration;
    protected final File projectFolder;
    protected List<BundleDependency> deployableMavenBundleDependencies;
    protected List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> deployableBundleDependencies;
    protected Map<ArtifactCoordinates, List<Artifact>> pluginsArtifactDependencies;
    protected Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> sharedDeployableBundleDescriptors;
    protected Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>> additionalPluginDependencies;
    protected Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>> pluginsBundleDependencies;
    protected File deployableArtifactRepositoryFolder;

    protected static MavenConfiguration getDefaultMavenConfiguration() {
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)MavenDeployableProjectModelBuilder.class.getClassLoader());
        Supplier localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation((File)localMavenRepository.get());
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        settingsSecurity.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        return mavenConfigurationBuilder.build();
    }

    protected AbstractMavenDeployableProjectModelBuilder(MavenConfiguration mavenConfiguration, File projectFolder) {
        this.mavenConfiguration = mavenConfiguration;
        this.projectFolder = projectFolder;
    }

    @Override
    public final DeployableProjectModel build() {
        File pom = this.getPomFromFolder(this.projectFolder);
        Model pomModel = MavenUtils.getPomModelFromFile((File)pom);
        this.deployableArtifactRepositoryFolder = this.mavenConfiguration.getLocalMavenRepositoryLocation();
        ArtifactCoordinates deployableArtifactCoordinates = this.getDeployableProjectArtifactCoordinates(pomModel);
        AetherMavenClient aetherMavenClient = new AetherMavenClient(this.mavenConfiguration);
        List<String> activeProfiles = this.mavenConfiguration.getActiveProfiles().orElse(Collections.emptyList());
        this.resolveDeployableDependencies(aetherMavenClient, pom, pomModel, activeProfiles);
        this.resolveDeployablePluginsData(this.deployableMavenBundleDependencies);
        this.resolveAdditionalPluginDependencies(aetherMavenClient, pomModel, activeProfiles, this.pluginsArtifactDependencies);
        return this.doBuild(pomModel, deployableArtifactCoordinates);
    }

    protected abstract DeployableProjectModel doBuild(Model var1, ArtifactCoordinates var2);

    protected abstract File getPomFromFolder(File var1);

    protected abstract boolean isIncludeTestDependencies();

    protected final List<String> getAttribute(Map<String, Object> attributes, String attribute) {
        if (attributes == null) {
            return Collections.emptyList();
        }
        List<String> attributeObject = attributes.getOrDefault(attribute, Collections.emptyList());
        Preconditions.checkArgument((boolean)(attributeObject instanceof List), (String)String.format("The '%s' attribute must be of '%s', found '%s'", attribute, List.class.getName(), attributeObject.getClass().getName()));
        return attributeObject;
    }

    protected final <T> T getSimpleAttribute(Map<String, Object> attributes, String attribute, T defaultValue) {
        return (T)attributes.getOrDefault(attribute, defaultValue);
    }

    protected org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor buildBundleDescriptor(ArtifactCoordinates artifactCoordinates) {
        return new BundleDescriptor.Builder().setArtifactId(artifactCoordinates.getArtifactId()).setGroupId(artifactCoordinates.getGroupId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setType(artifactCoordinates.getType()).setClassifier(artifactCoordinates.getClassifier()).build();
    }

    private ArtifactCoordinates getDeployableProjectArtifactCoordinates(Model pomModel) {
        ApplicationGAVModel deployableGAVModel = new ApplicationGAVModel(pomModel.getGroupId(), pomModel.getArtifactId(), pomModel.getVersion());
        return ArtifactUtils.getDeployableArtifactCoordinates(pomModel, deployableGAVModel);
    }

    private void resolveDeployableDependencies(AetherMavenClient aetherMavenClient, File pom, Model pomModel, List<String> activeProfiles) {
        DeployableDependencyResolver deployableDependencyResolver = new DeployableDependencyResolver(aetherMavenClient);
        this.deployableMavenBundleDependencies = deployableDependencyResolver.resolveDeployableDependencies(pom, this.isIncludeTestDependencies(), this.getMavenReactorResolver());
        this.deployableMavenBundleDependencies = this.resolveSystemScopeDependencies(aetherMavenClient, this.deployableMavenBundleDependencies);
        List<Artifact> deployableArtifactDependencies = ArtifactUtils.updateArtifactsSharedState(this.deployableMavenBundleDependencies, ArtifactUtils.updatePackagesResources(ArtifactUtils.toApplicationModelArtifacts(this.deployableMavenBundleDependencies)), pomModel, activeProfiles);
        this.deployableBundleDependencies = deployableArtifactDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList());
        this.sharedDeployableBundleDescriptors = this.deployableBundleDependencies.stream().filter(bd -> deployableArtifactDependencies.stream().anyMatch(artifact -> artifact.isShared() && bd.getDescriptor().getGroupId().equals(artifact.getArtifactCoordinates().getGroupId()) && bd.getDescriptor().getArtifactId().equals(artifact.getArtifactCoordinates().getArtifactId()))).map(org.mule.runtime.module.artifact.api.descriptor.BundleDependency::getDescriptor).collect(Collectors.toSet());
    }

    protected Optional<MavenReactorResolver> getMavenReactorResolver() {
        return Optional.empty();
    }

    private List<BundleDependency> resolveSystemScopeDependencies(AetherMavenClient aetherMavenClient, List<BundleDependency> deployableMavenBundleDependencies) {
        ArrayList systemScopeDependenciesTransitiveDependencies = new ArrayList();
        List<BundleDependency> result = deployableMavenBundleDependencies.stream().map(bundleDependency -> {
            if ("mule-plugin".equals(bundleDependency.getDescriptor().getClassifier().orElse(null)) && BundleScope.SYSTEM.equals((Object)bundleDependency.getScope())) {
                try (MuleSystemPluginMavenReactorResolver reactor = new MuleSystemPluginMavenReactorResolver(new File(bundleDependency.getBundleUri()), (MavenClient)aetherMavenClient);){
                    BundleDependency systemScopeDependency = (BundleDependency)aetherMavenClient.resolveArtifactDependencies(Collections.singletonList(bundleDependency.getDescriptor()), Optional.of(this.deployableArtifactRepositoryFolder), Optional.of(reactor)).get(0);
                    systemScopeDependenciesTransitiveDependencies.addAll(this.collectTransitivePluginDependencies(systemScopeDependency));
                    BundleDependency bundleDependency2 = systemScopeDependency;
                    return bundleDependency2;
                }
            }
            return bundleDependency;
        }).collect(Collectors.toList());
        result.addAll(systemScopeDependenciesTransitiveDependencies);
        return this.getUniqueDependencies(result);
    }

    private List<BundleDependency> getUniqueDependencies(List<BundleDependency> dependencies) {
        HashMap<String, BundleDependency> uniqueDependencies = new HashMap<String, BundleDependency>();
        for (BundleDependency dependency : dependencies) {
            BundleDescriptor descriptor = dependency.getDescriptor();
            String pluginKey = descriptor.getGroupId() + ":" + descriptor.getArtifactId() + ":" + descriptor.getClassifier().orElse("");
            uniqueDependencies.putIfAbsent(pluginKey, dependency);
        }
        return new ArrayList<BundleDependency>(uniqueDependencies.values());
    }

    private List<BundleDependency> collectTransitivePluginDependencies(BundleDependency rootDependency) {
        ArrayList<BundleDependency> allTransitivePluginDependencies = new ArrayList<BundleDependency>();
        for (BundleDependency transitiveDependency : rootDependency.getTransitiveDependencies()) {
            if (!transitiveDependency.getDescriptor().getClassifier().map("mule-plugin"::equals).orElse(false).booleanValue()) continue;
            allTransitivePluginDependencies.add(transitiveDependency);
            allTransitivePluginDependencies.addAll(this.collectTransitivePluginDependencies(transitiveDependency));
        }
        return allTransitivePluginDependencies;
    }

    private void resolveAdditionalPluginDependencies(AetherMavenClient aetherMavenClient, Model pomModel, List<String> activeProfiles, Map<ArtifactCoordinates, List<Artifact>> pluginsDependencies) {
        List<Plugin> initialAdditionalPluginDependencies = this.findArtifactPackagerPlugin(pomModel, activeProfiles).map(this::getAdditionalPluginDependencies).orElse(Collections.emptyList());
        AdditionalPluginDependenciesResolver additionalPluginDependenciesResolver = new AdditionalPluginDependenciesResolver(aetherMavenClient, initialAdditionalPluginDependencies, new File("temp"), this.getPomModels());
        this.additionalPluginDependencies = this.toPluginDependencies(additionalPluginDependenciesResolver.resolveDependencies(this.deployableMavenBundleDependencies, pluginsDependencies));
    }

    protected Map<ArtifactCoordinates, Supplier<Model>> getPomModels() {
        return Collections.emptyMap();
    }

    private void resolveDeployablePluginsData(List<BundleDependency> deployableMavenBundleDependencies) {
        this.pluginsArtifactDependencies = new DeployablePluginsDependenciesResolver().resolve(deployableMavenBundleDependencies);
        HashMap pluginsBundleDescriptors = new HashMap();
        this.pluginsArtifactDependencies.keySet().forEach(pluginArtifactCoordinates -> pluginsBundleDescriptors.put(pluginArtifactCoordinates, this.buildBundleDescriptor((ArtifactCoordinates)pluginArtifactCoordinates)));
        this.pluginsBundleDependencies = new HashMap<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>>();
        this.pluginsArtifactDependencies.forEach((pluginArtifactCoordinates, pluginDependencies) -> this.pluginsBundleDependencies.put((org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginsBundleDescriptors.get(pluginArtifactCoordinates), pluginDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList())));
        this.deployableBundleDependencies = this.deployableBundleDependencies.stream().map(dbd -> new BundleDependency.Builder(dbd).setTransitiveDependencies(this.pluginsBundleDependencies.get(dbd.getDescriptor())).build()).collect(Collectors.toList());
    }

    private Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>> toPluginDependencies(Map<BundleDependency, List<BundleDependency>> pluginsAndDependencies) {
        return pluginsAndDependencies.entrySet().stream().collect(Collectors.toMap(entry -> this.deployableBundleDependencies.stream().filter(bd -> bd.getDescriptor().getGroupId().equals(((BundleDependency)entry.getKey()).getDescriptor().getGroupId()) && bd.getDescriptor().getArtifactId().equals(((BundleDependency)entry.getKey()).getDescriptor().getArtifactId())).map(org.mule.runtime.module.artifact.api.descriptor.BundleDependency::getDescriptor).findAny().get(), entry -> {
            List<Artifact> deployableArtifactDependencies = ArtifactUtils.updatePackagesResources(ArtifactUtils.toApplicationModelArtifacts((List)entry.getValue()));
            return deployableArtifactDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList());
        }));
    }

    private Function<Artifact, org.mule.runtime.module.artifact.api.descriptor.BundleDependency> createBundleDependencyFromPackagerDependency(Function<URI, URI> uriResolver) {
        return d -> {
            URI bundle = d.getUri();
            if (!d.getUri().isAbsolute()) {
                bundle = (URI)uriResolver.apply(d.getUri());
            }
            return new BundleDependency.Builder().setDescriptor(new BundleDescriptor.Builder().setArtifactId(d.getArtifactCoordinates().getArtifactId()).setGroupId(d.getArtifactCoordinates().getGroupId()).setClassifier(d.getArtifactCoordinates().getClassifier()).setType(d.getArtifactCoordinates().getType()).setVersion(d.getArtifactCoordinates().getVersion()).setBaseVersion(d.getArtifactCoordinates().getVersion()).build()).setBundleUri(bundle).setPackages(d.getPackages() == null ? Collections.emptySet() : Sets.newHashSet((Object[])d.getPackages())).setResources(d.getResources() == null ? Collections.emptySet() : Sets.newHashSet((Object[])d.getResources())).build();
        };
    }

    private Function<URI, URI> getDeployableArtifactRepositoryUriResolver() {
        return uri -> new File(this.deployableArtifactRepositoryFolder, uri.toString()).toURI();
    }

    private Optional<org.apache.maven.model.Plugin> findArtifactPackagerPlugin(Model model, List<String> activeProfiles) {
        Stream basePlugin = Stream.empty();
        Build build = model.getBuild();
        if (build != null) {
            basePlugin = this.findArtifactPackagerPlugin(build.getPlugins()).map(Stream::of).orElse(Stream.empty());
        }
        List sortedActiveProfiles = activeProfiles.stream().sorted(String::compareTo).collect(Collectors.toList());
        Stream<org.apache.maven.model.Plugin> packagerConfigsForActivePluginsStream = model.getProfiles().stream().filter(profile -> sortedActiveProfiles.contains(profile.getId())).map(profile -> this.findArtifactPackagerPlugin(profile.getBuild() != null ? profile.getBuild().getPlugins() : null)).filter(plugin -> !plugin.equals(Optional.empty())).map(Optional::get);
        return Stream.concat(basePlugin, packagerConfigsForActivePluginsStream).reduce((p1, p2) -> {
            p1.setConfiguration((Object)Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)p2.getConfiguration()), (Xpp3Dom)((Xpp3Dom)p1.getConfiguration())));
            p1.getDependencies().addAll(p2.getDependencies());
            return p1;
        });
    }

    private Optional<org.apache.maven.model.Plugin> findArtifactPackagerPlugin(List<org.apache.maven.model.Plugin> plugins) {
        if (plugins != null) {
            return plugins.stream().filter(plugin -> plugin.getArtifactId().equals("mule-maven-plugin") && plugin.getGroupId().equals("org.mule.tools.maven") || plugin.getArtifactId().equals("mule-extensions-maven-plugin") && plugin.getGroupId().equals("org.mule.runtime.plugins")).findFirst();
        }
        return Optional.empty();
    }

    private List<Plugin> getAdditionalPluginDependencies(org.apache.maven.model.Plugin packagingPlugin) {
        Xpp3Dom[] pluginsDom;
        Xpp3Dom additionalPluginDependenciesDom;
        ArrayList<Plugin> pluginsAdditionalLibraries = new ArrayList<Plugin>();
        Object configuration = packagingPlugin.getConfiguration();
        if (configuration != null && (additionalPluginDependenciesDom = ((Xpp3Dom)configuration).getChild("additionalPluginDependencies")) != null && (pluginsDom = additionalPluginDependenciesDom.getChildren("plugin")) != null) {
            for (Xpp3Dom pluginDom : pluginsDom) {
                String pluginGroupId = this.getChildParameterValue(pluginDom, GROUP_ID, true);
                String pluginArtifactId = this.getChildParameterValue(pluginDom, ARTIFACT_ID, true);
                ArrayList<Dependency> additionalDependencyDependencies = new ArrayList<Dependency>();
                Xpp3Dom dependenciesDom = pluginDom.getChild("additionalDependencies");
                if (dependenciesDom != null) {
                    for (Xpp3Dom dependencyDom : dependenciesDom.getChildren("dependency")) {
                        Dependency dependency = new Dependency();
                        dependency.setGroupId(this.getChildParameterValue(dependencyDom, GROUP_ID, true));
                        dependency.setArtifactId(this.getChildParameterValue(dependencyDom, ARTIFACT_ID, true));
                        dependency.setVersion(this.getChildParameterValue(dependencyDom, VERSION, true));
                        String type = this.getChildParameterValue(dependencyDom, "type", false);
                        dependency.setType(type == null ? "jar" : type);
                        dependency.setClassifier(this.getChildParameterValue(dependencyDom, "classifier", false));
                        dependency.setSystemPath(this.getChildParameterValue(dependencyDom, "systemPath", false));
                        additionalDependencyDependencies.add(dependency);
                    }
                }
                Plugin plugin = new Plugin();
                plugin.setGroupId(pluginGroupId);
                plugin.setArtifactId(pluginArtifactId);
                plugin.setAdditionalDependencies(additionalDependencyDependencies);
                pluginsAdditionalLibraries.add(plugin);
            }
        }
        return pluginsAdditionalLibraries;
    }

    private String getChildParameterValue(Xpp3Dom element, String childName, boolean validate) {
        String childValue;
        Xpp3Dom child = element.getChild(childName);
        String string = childValue = child != null ? child.getValue() : null;
        if (StringUtils.isEmpty((CharSequence)childValue) && validate) {
            throw new IllegalArgumentException("Expecting child element with not null value " + childName);
        }
        return childValue;
    }

    private static class MuleSystemPluginMavenReactorResolver
    implements MavenReactorResolver,
    AutoCloseable {
        private static final String POM = "pom";
        private final File temporaryFolder;
        private final Model effectiveModel;
        private final File pomFile;
        private final File artifactFile;

        public MuleSystemPluginMavenReactorResolver(File artifactFile, MavenClient mavenClient) {
            try {
                this.temporaryFolder = Files.createTempDirectory("tmpDirPrefix" + Math.random(), new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            this.effectiveModel = mavenClient.getEffectiveModel(artifactFile, Optional.of(this.temporaryFolder));
            this.pomFile = this.effectiveModel.getPomFile();
            this.artifactFile = artifactFile;
        }

        public File findArtifact(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                if (bundleDescriptor.getType().equals(POM)) {
                    return this.pomFile;
                }
                return this.artifactFile;
            }
            return null;
        }

        public List<String> findVersions(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                return Collections.singletonList(this.effectiveModel.getVersion());
            }
            return Collections.emptyList();
        }

        private boolean checkArtifact(BundleDescriptor bundleDescriptor) {
            return this.effectiveModel.getGroupId().equals(bundleDescriptor.getGroupId()) && this.effectiveModel.getArtifactId().equals(bundleDescriptor.getArtifactId()) && this.effectiveModel.getVersion().equals(bundleDescriptor.getVersion());
        }

        @Override
        public void close() {
            FileUtils.deleteQuietly((File)this.temporaryFolder);
        }
    }
}

