/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.deployable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public final class DeployableProjectModel {
    private final List<String> packages;
    private final List<String> resources;
    private final BundleDescriptor descriptor;
    private final Supplier<MuleDeployableModel> deployableModelSupplier;
    private final File projectFolder;
    private final List<BundleDependency> dependencies;
    private final Set<BundleDescriptor> sharedLibraries;
    private final Map<BundleDescriptor, List<BundleDependency>> additionalPluginDependencies;
    private final List<Path> resourcesPath;

    public DeployableProjectModel(List<String> packages, List<String> resources, List<Path> resourcesPath, BundleDescriptor descriptor, Supplier<MuleDeployableModel> deployableModelSupplier, File projectFolder, List<BundleDependency> dependencies, Set<BundleDescriptor> sharedLibraries, Map<BundleDescriptor, List<BundleDependency>> additionalPluginDependencies) {
        this.packages = ImmutableList.copyOf(packages);
        this.resources = ImmutableList.copyOf(resources);
        this.resourcesPath = ImmutableList.copyOf(resourcesPath);
        this.descriptor = Objects.requireNonNull(descriptor);
        this.deployableModelSupplier = new LazyValue(Objects.requireNonNull(deployableModelSupplier));
        this.projectFolder = Objects.requireNonNull(projectFolder);
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.sharedLibraries = ImmutableSet.copyOf(sharedLibraries);
        this.additionalPluginDependencies = ImmutableMap.copyOf(additionalPluginDependencies);
    }

    public void validate() throws ArtifactActivationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        for (BundleDescriptor sharedLibDescriptor : this.sharedLibraries) {
            if (!this.dependencies.stream().noneMatch(dep -> dep.getDescriptor().equals((Object)sharedLibDescriptor))) continue;
            validationMessages.add(String.format("Artifact '%s' is declared as a sharedLibrary but is not a dependency of the project", sharedLibDescriptor.getGroupId() + ":" + sharedLibDescriptor.getArtifactId()));
        }
        for (BundleDescriptor pluginDescriptor : this.additionalPluginDependencies.keySet()) {
            if (!this.dependencies.stream().noneMatch(dep -> dep.getDescriptor().equals((Object)pluginDescriptor))) continue;
            validationMessages.add(String.format("Mule Plugin '%s' is declared in additionalPluginDependencies but is not a dependency of the project", pluginDescriptor.getGroupId() + ":" + pluginDescriptor.getArtifactId()));
        }
        this.getRepeatedDependencies(this.dependencies).forEach((key, value) -> validationMessages.add(String.format("Mule Plugin '%s' is depended upon in the project with multiple versions ('%s') in the dependency graph.", key, value.stream().map(BundleDescriptor::getVersion).collect(Collectors.joining(", ")))));
        if (!validationMessages.isEmpty()) {
            throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)validationMessages.stream().collect(Collectors.joining(" * ", System.lineSeparator() + " * ", System.lineSeparator()))));
        }
    }

    private Map<String, List<BundleDescriptor>> getRepeatedDependencies(List<BundleDependency> dependencies) {
        HashMap<String, List> repeatedDependencies = new HashMap<String, List>();
        for (BundleDependency dependency : dependencies) {
            BundleDescriptor descriptor = dependency.getDescriptor();
            String pluginKey = descriptor.getGroupId() + ":" + descriptor.getArtifactId() + ":" + descriptor.getClassifier().orElse("");
            repeatedDependencies.computeIfAbsent(pluginKey, k -> new ArrayList());
            ((List)repeatedDependencies.get(pluginKey)).add(descriptor);
        }
        return repeatedDependencies.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public List<Path> getResourcesPath() {
        return this.resourcesPath;
    }

    public BundleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public MuleDeployableModel getDeployableModel() {
        return this.deployableModelSupplier.get();
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public List<BundleDependency> getDependencies() {
        return this.dependencies;
    }

    public Set<BundleDescriptor> getSharedLibraries() {
        return this.sharedLibraries;
    }

    public Map<BundleDescriptor, List<BundleDependency>> getAdditionalPluginDependencies() {
        return this.additionalPluginDependencies;
    }
}

