/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.impl.instrument;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.metrics.api.instrument.LongCounter;
import org.mule.runtime.metrics.api.instrument.builder.LongCounterBuilder;
import org.mule.runtime.metrics.api.meter.Meter;
import org.mule.runtime.metrics.exporter.api.MeterExporter;
import org.mule.runtime.metrics.impl.instrument.repository.InstrumentRepository;

public class DefaultLongCounter
implements LongCounter {
    private final String name;
    private final String description;
    private final String unit;
    private final Meter meter;
    private final AtomicLong value = new AtomicLong(0L);
    private Supplier<Long> valueSupplier = this.value::get;
    private BiConsumer<Long, Map<String, String>> addOperation = this.getDefaultAddOperation();
    private Function<Map<String, String>, Long> incrementAndGetOperation = this.getDefaultIncrementAndGetOperation();

    public static DefaultLongCounterBuilder builder(String name, Meter meter) {
        return new DefaultLongCounterBuilder(name, meter);
    }

    private DefaultLongCounter(String name, String description, String unit, Meter meter) {
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.meter = meter;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Meter getMeter() {
        return this.meter;
    }

    public void add(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("The value to add must be positive");
        }
        this.addOperation.accept(value, Collections.emptyMap());
    }

    public void add(long value, Map<String, String> attributes) {
        this.addOperation.accept(value, attributes);
    }

    public long getValueAsLong() {
        return this.valueSupplier.get();
    }

    public String getUnit() {
        return this.unit;
    }

    public int getValueAsInt() {
        return this.valueSupplier.get().intValue();
    }

    public int incrementAndGetAsInt() {
        return this.incrementAndGetOperation.apply(Collections.emptyMap()).intValue();
    }

    public long incrementAndGetAsLong() {
        return this.incrementAndGetOperation.apply(Collections.emptyMap());
    }

    public void reset() {
        this.value.set(0L);
    }

    private BiConsumer<Long, Map<String, String>> getDefaultAddOperation() {
        return (delta, context) -> this.value.addAndGet((long)delta);
    }

    private Function<Map<String, String>, Long> getDefaultIncrementAndGetOperation() {
        return contextAttributes -> this.value.incrementAndGet();
    }

    private void setIncrementAndGetOperation(Function<Map<String, String>, Long> incrementAndGetOperation) {
        this.incrementAndGetOperation = incrementAndGetOperation;
    }

    private void setAddOperation(BiConsumer<Long, Map<String, String>> addOperation) {
        this.addOperation = addOperation;
    }

    private void setValueSupplier(Supplier<Long> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    public static class DefaultLongCounterBuilder
    implements LongCounterBuilder {
        private final String name;
        private final Meter meter;
        private InstrumentRepository instrumentRepository;
        private String description;
        private String unit;
        private MeterExporter meterExporter;
        private BiConsumer<Long, Map<String, String>> addOperation;
        private Function<Map<String, String>, Long> incrementAndGetOperation;
        private Supplier<Long> valueSupplier;

        public DefaultLongCounterBuilder(String name, Meter meter) {
            this.name = name;
            this.meter = meter;
        }

        public DefaultLongCounterBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public DefaultLongCounterBuilder withUnit(String unit) {
            this.unit = unit;
            return this;
        }

        public DefaultLongCounterBuilder withInstrumentRepository(InstrumentRepository instrumentRepository) {
            this.instrumentRepository = instrumentRepository;
            return this;
        }

        public DefaultLongCounterBuilder withMeterExporter(MeterExporter meterExporter) {
            this.meterExporter = meterExporter;
            return this;
        }

        public LongCounter build() {
            LongCounter longCounter = Optional.ofNullable(this.instrumentRepository).map(repository -> (LongCounter)repository.create(this.name, name -> this.doBuild())).orElseGet(this::doBuild);
            return longCounter;
        }

        private LongCounter doBuild() {
            DefaultLongCounter longCounter = new DefaultLongCounter(this.name, this.description, this.unit, this.meter);
            if (this.valueSupplier != null) {
                longCounter.setValueSupplier(this.valueSupplier);
            }
            if (this.addOperation != null) {
                longCounter.setAddOperation(this.addOperation);
            }
            if (this.incrementAndGetOperation != null) {
                longCounter.setIncrementAndGetOperation(this.incrementAndGetOperation);
            }
            if (this.meterExporter != null) {
                this.meterExporter.enableExport((LongCounter)longCounter);
            }
            return longCounter;
        }

        public DefaultLongCounterBuilder withAddOperation(BiConsumer<Long, Map<String, String>> addOperation) {
            this.addOperation = addOperation;
            return this;
        }

        public DefaultLongCounterBuilder withIncrementAndGetOperation(Function<Map<String, String>, Long> incrementAndGetOperation) {
            this.incrementAndGetOperation = incrementAndGetOperation;
            return this;
        }

        public DefaultLongCounterBuilder withValueSupplier(Supplier<Long> valueSupplier) {
            this.valueSupplier = valueSupplier;
            return this;
        }
    }
}

