/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.impl.optel.resources.inmemory;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import org.mule.runtime.metrics.api.exporters.ExporterMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryExportersMetrics
extends ExporterMetrics
implements MetricExporter {
    private static final Logger METRICS_LOGGER = LoggerFactory.getLogger(OpenTelemetryExportersMetrics.class);
    public static final String PROCESSED_SPANS = "processedSpans";
    public static final String PROCESSED_LOGS = "processedLogs";
    public static final String DELAYED_SPANS = "delayedSpans";
    public static final String DELAYED_LOGS = "delayedLogs";
    public static final String DROPPED = "dropped";
    public static final String SPANS = "spans";
    public static final String DELAYED = "delayed";
    public static final String LOG_RECORDS = "log records";
    private Long batchProcessorDroppedSpans = 0L;
    private Long batchProcessorDroppedLogRecords = 0L;
    private Long batchProcessorDelayedSpans = 0L;
    private Long batchProcessorDelayedLogRecords = 0L;
    private Long batchProcessorProcessedSpans = 0L;
    private Long batchProcessorProcessedLogRecords = 0L;

    public CompletableResultCode export(Collection<MetricData> metrics) {
        metrics.forEach(metricData -> {
            if (metricData.getName().equals(PROCESSED_SPANS)) {
                this.updateReceivedSpansAndWarnIfNecessary((MetricData)metricData);
            }
            if (metricData.getName().equals(PROCESSED_LOGS)) {
                this.updateReceivedLogRecordsAndWarnIfNecessary((MetricData)metricData);
            }
            if (metricData.getName().equals(DELAYED_SPANS)) {
                this.updateDelayedSpansAndWarnIfNecessary((MetricData)metricData);
            }
            if (metricData.getName().equals(DELAYED_LOGS)) {
                this.updateDelayedLogRecordsAndWarnIfNecessary((MetricData)metricData);
            }
        });
        return CompletableResultCode.ofSuccess();
    }

    private void updateDelayedLogRecordsAndWarnIfNecessary(MetricData metricData) {
        long previousDelayedLogRecords = this.batchProcessorDelayedLogRecords;
        this.updateDelayedLogRecords(metricData);
        this.alertIfNecessary(previousDelayedLogRecords, this.batchProcessorDelayedLogRecords, this.batchProcessorProcessedLogRecords, LOG_RECORDS, DELAYED);
    }

    private void updateDelayedSpansAndWarnIfNecessary(MetricData metricData) {
        long previousDelayedSpans = this.batchProcessorDelayedSpans;
        this.updateDelayedSpans(metricData);
        this.alertIfNecessary(previousDelayedSpans, this.batchProcessorDelayedSpans, this.batchProcessorProcessedSpans, SPANS, DELAYED);
    }

    private void updateReceivedSpansAndWarnIfNecessary(MetricData metricData) {
        long previousDroppedSpans = this.batchProcessorDroppedSpans;
        this.updateReceivedSpans(metricData);
        this.alertIfNecessary(previousDroppedSpans, this.batchProcessorDroppedSpans, this.batchProcessorProcessedSpans, SPANS, DROPPED);
    }

    private void updateReceivedLogRecordsAndWarnIfNecessary(MetricData metricData) {
        long previousDroppedLogRecords = this.batchProcessorDroppedLogRecords;
        this.updateReceivedLogRecords(metricData);
        this.alertIfNecessary(previousDroppedLogRecords, this.batchProcessorDroppedLogRecords, this.batchProcessorProcessedSpans, LOG_RECORDS, DROPPED);
    }

    private void updateDelayedSpans(MetricData processedSpansMetricData) {
        processedSpansMetricData.getData().getPoints().forEach(pointData -> {
            this.batchProcessorDelayedSpans = ((LongPointData)pointData).getValue();
        });
    }

    private void updateDelayedLogRecords(MetricData processedLogsMetricData) {
        processedLogsMetricData.getData().getPoints().forEach(pointData -> {
            this.batchProcessorDelayedLogRecords = ((LongPointData)pointData).getValue();
        });
    }

    private void updateReceivedSpans(MetricData processedSpansMetricData) {
        processedSpansMetricData.getData().getPoints().forEach(pointData -> {
            if (Boolean.TRUE.equals(pointData.getAttributes().get(AttributeKey.booleanKey((String)DROPPED)))) {
                this.batchProcessorDroppedSpans = ((LongPointData)pointData).getValue();
            } else {
                this.batchProcessorProcessedSpans = ((LongPointData)pointData).getValue();
            }
        });
    }

    private void updateReceivedLogRecords(MetricData processedLogRecordsMetricData) {
        processedLogRecordsMetricData.getData().getPoints().forEach(pointData -> {
            if (Boolean.TRUE.equals(pointData.getAttributes().get(AttributeKey.booleanKey((String)DROPPED)))) {
                this.batchProcessorDroppedLogRecords = ((LongPointData)pointData).getValue();
            } else {
                this.batchProcessorProcessedLogRecords = ((LongPointData)pointData).getValue();
            }
        });
    }

    private void alertIfNecessary(long previousValue, long currentValue, long totalProcessedValue, String signalItemName, String backpressureActionName) {
        if (currentValue > previousValue) {
            METRICS_LOGGER.warn("Export queue backpressure: {} {} have been {}. Total {} {} since the export started: {} with {} processed.", new Object[]{currentValue - previousValue, signalItemName, backpressureActionName, backpressureActionName, signalItemName, currentValue, totalProcessedValue});
            String muleAlertData = String.format("Resource: %s, Action: %s", signalItemName, backpressureActionName);
            onDropOrBlockAlertCallbacks.forEach((key, value) -> value.accept(key, muleAlertData));
        }
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        OpenTelemetryExportersMetrics.clearQueueFullCallbacks();
        return CompletableResultCode.ofSuccess();
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    public Long getBatchProcessorDroppedSpans() {
        return this.batchProcessorDroppedSpans;
    }

    public Long getBatchProcessorDroppedLogRecords() {
        return this.batchProcessorDroppedLogRecords;
    }

    public Long getBatchProcessorDelayedSpans() {
        return this.batchProcessorDelayedSpans;
    }

    public Long getBatchProcessorDelayedLogRecords() {
        return this.batchProcessorDelayedLogRecords;
    }

    public Long getBatchProcessorProcessedSpans() {
        return this.batchProcessorProcessedSpans;
    }

    public Long getBatchProcessorProcessedLogRecords() {
        return this.batchProcessorProcessedLogRecords;
    }
}

