/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.impl.capturer;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CapturingMeterExporterWrapper
implements MetricExporter {
    private final Set<InMemoryMetricExporter> meterSniffers = ConcurrentHashMap.newKeySet();

    public CompletableResultCode export(Collection<MetricData> metrics) {
        this.meterSniffers.forEach(sniffer -> sniffer.export(metrics));
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return null;
    }

    public CompletableResultCode shutdown() {
        return null;
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    public InMemoryMetricExporter getExportedMeterSniffer() {
        InMemoryMetricExporter meterSniffer = InMemoryMetricExporter.create();
        this.meterSniffers.add(meterSniffer);
        return meterSniffer;
    }

    public void dispose(InMemoryMetricExporter meterSniffer) {
        this.meterSniffers.remove(meterSniffer);
    }

    public static final class InMemoryMetricExporter
    implements MetricExporter {
        private final Queue<MetricData> finishedMetricItems = new ConcurrentLinkedQueue<MetricData>();
        private final AggregationTemporality aggregationTemporality;
        private boolean isStopped = false;

        private InMemoryMetricExporter(AggregationTemporality aggregationTemporality) {
            this.aggregationTemporality = aggregationTemporality;
        }

        public static InMemoryMetricExporter create() {
            return InMemoryMetricExporter.create(AggregationTemporality.CUMULATIVE);
        }

        public static InMemoryMetricExporter create(AggregationTemporality aggregationTemporality) {
            return new InMemoryMetricExporter(aggregationTemporality);
        }

        public List<MetricData> getFinishedMetricItems() {
            return List.copyOf(this.finishedMetricItems);
        }

        public void reset() {
            this.finishedMetricItems.clear();
        }

        public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
            return this.aggregationTemporality;
        }

        public CompletableResultCode export(Collection<MetricData> metrics) {
            if (this.isStopped) {
                return CompletableResultCode.ofFailure();
            }
            this.finishedMetricItems.addAll(metrics);
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode flush() {
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode shutdown() {
            this.isStopped = true;
            this.finishedMetricItems.clear();
            return CompletableResultCode.ofSuccess();
        }
    }
}

