/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class SchemaCollector {
    private final Map<String, InputStream> schemas = new LinkedHashMap<String, InputStream>();

    private SchemaCollector() {
    }

    public static SchemaCollector getInstance() {
        return new SchemaCollector();
    }

    public SchemaCollector addSchema(File schema) {
        try {
            this.schemas.put(schema.toURI().toString(), new FileInputStream(schema));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error while adding schema file [" + schema.getName() + "]", e);
        }
        return this;
    }

    public SchemaCollector addSchema(URL schemaUrl) {
        try {
            this.schemas.put(schemaUrl.toString(), schemaUrl.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Error while adding schema of URL [" + schemaUrl + "]", e);
        }
        return this;
    }

    public SchemaCollector addSchema(String name, String schemaContent) {
        this.schemas.put(name, new ByteArrayInputStream(schemaContent.getBytes()));
        return this;
    }

    public SchemaCollector addSchema(String schemaUrl) {
        try {
            this.addSchema(new URL(schemaUrl));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("The specified URL [" + schemaUrl + "] is invalid", e);
        }
        return this;
    }

    public SchemaCollector addSchema(String name, InputStream schemaContent) {
        this.schemas.put(name, schemaContent);
        return this;
    }

    public Map<String, InputStream> collect() {
        return Collections.unmodifiableMap(this.schemas);
    }
}

