/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.AttributeFieldTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectKeyBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.xml.ModelFactory;
import org.mule.metadata.xml.SchemaCollector;
import org.mule.metadata.xml.handler.HandlerManager;
import org.mule.metadata.xml.utils.SchemaHelper;
import org.w3c.dom.TypeInfo;

public class XmlTypeLoader
implements TypeLoader {
    public static final String TEXT_CONTENT_FIELD_NAME = "text()";
    public static MetadataFormat XML = MetadataFormat.XML;
    private HandlerManager handlerManager;
    private ModelFactory modelFactory;
    private Map<QName, TypeBuilder> types;

    public XmlTypeLoader(SchemaCollector schemaCollector) {
        this(ModelFactory.fromSchemas(schemaCollector.collect()));
    }

    public XmlTypeLoader(ModelFactory modelFactory) {
        this.modelFactory = modelFactory;
        this.types = new HashMap<QName, TypeBuilder>();
        this.handlerManager = new HandlerManager();
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        return this.load(typeIdentifier != null ? QName.valueOf(typeIdentifier) : null, typeAlias);
    }

    public Optional<MetadataType> load(QName qName, String typeAlias) {
        try {
            QName rootElement;
            XSModel model = this.modelFactory.getModel();
            QName qName2 = rootElement = qName == null ? (QName)this.modelFactory.getRootElementName().orElse(null) : qName;
            if (model != null) {
                XSElementDeclaration elementDeclaration = model.getElementDeclaration(rootElement.getLocalPart(), rootElement.getNamespaceURI());
                if (elementDeclaration == null) {
                    return Optional.empty();
                }
                BaseTypeBuilder rootBuilder = BaseTypeBuilder.create((MetadataFormat)XML);
                ObjectTypeBuilder rootObject = rootBuilder.objectType();
                rootObject.id(rootElement.toString());
                this.modelFactory.getExample().ifPresent(arg_0 -> ((ObjectTypeBuilder)rootObject).with(arg_0));
                ObjectFieldTypeBuilder field = rootObject.addField();
                ObjectKeyBuilder key = field.key(rootElement);
                this.processAttributes(elementDeclaration, key);
                BaseTypeBuilder valueBuilder = field.value();
                this.processValue(elementDeclaration, valueBuilder);
                MetadataTypeUtils.addTypeAlias((TypeBuilder)rootBuilder, (String)typeAlias);
                return Optional.ofNullable(rootBuilder.build());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processValue(XSElementDeclaration elementDeclaration, BaseTypeBuilder typeBuilder) {
        XSTypeDefinition typeDefinition = elementDeclaration.getTypeDefinition();
        if (typeDefinition instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl complexType = (XSComplexTypeDecl)typeDefinition;
            Optional<Short> groupType = this.getGroupType(complexType);
            if (groupType.isPresent() && groupType.get().equals((short)2)) {
                this.processUnionType(typeBuilder, complexType);
            } else if (1 == complexType.getContentType()) {
                typeBuilder.stringType();
            } else {
                Optional<QName> typeName;
                ObjectTypeBuilder objectType = typeBuilder.objectType();
                if (3 == complexType.getContentType()) {
                    objectType.addField().key(TEXT_CONTENT_FIELD_NAME).value().stringType();
                }
                if ((typeName = this.getTypeName(typeDefinition)).isPresent()) {
                    objectType.id(typeName.get().toString());
                    this.types.put(typeName.get(), (TypeBuilder)objectType);
                }
                this.processAnnotations(complexType, objectType);
                this.processElements(complexType, objectType);
            }
        } else if (typeDefinition instanceof XSSimpleTypeDecl) {
            this.handlerManager.handle((XSSimpleTypeDecl)typeDefinition, SchemaHelper.getDefaultValue(elementDeclaration), typeBuilder);
        }
    }

    private void processUnionType(BaseTypeBuilder typeBuilder, XSComplexTypeDecl complexType) {
        XSTerm term;
        UnionTypeBuilder unionType = typeBuilder.unionType();
        XSParticle particle = complexType.getParticle();
        if (particle != null && (term = particle.getTerm()) instanceof XSModelGroup) {
            XSModelGroup xsModelGroup = (XSModelGroup)term;
            XSObjectList particles = xsModelGroup.getParticles();
            for (Object xsObject : particles) {
                XSParticle part;
                XSTerm element;
                if (!(xsObject instanceof XSParticle) || !((element = (part = (XSParticle)xsObject).getTerm()) instanceof XSElementDeclaration)) continue;
                ObjectTypeBuilder objectType = unionType.of().objectType();
                XSElementDeclaration elementDeclaration = (XSElementDeclaration)element;
                String name = element.getName();
                String namespace = element.getNamespace();
                ObjectFieldTypeBuilder field = objectType.addField();
                ObjectKeyBuilder key = field.key(new QName(namespace, name));
                this.processAttributes(elementDeclaration, key);
                field.required(part.getMinOccurs() > 0);
                BaseTypeBuilder fieldValue = field.value();
                this.processValue(elementDeclaration, fieldValue);
            }
        }
    }

    private Optional<Short> getGroupType(XSComplexTypeDecl complexType) {
        XSTerm term;
        XSParticle particle = complexType.getParticle();
        if (particle != null && (term = particle.getTerm()) instanceof XSModelGroup) {
            return Optional.of(((XSModelGroup)term).getCompositor());
        }
        return Optional.empty();
    }

    private void processAnnotations(XSComplexTypeDecl complexType, ObjectTypeBuilder objectType) {
        XSObjectList annotations = complexType.getAnnotations();
        for (Object annotation : annotations) {
            XSAnnotation xsAnnotation = (XSAnnotation)annotation;
            Collection<SchemaHelper.XmlDoc> documentation = SchemaHelper.getDocumentation(xsAnnotation.getAnnotationString());
            for (SchemaHelper.XmlDoc xmlDoc : documentation) {
                objectType.description((String)xmlDoc.getLang().orElse(null), xmlDoc.getContent());
            }
        }
    }

    private void processAttributes(XSElementDeclaration elementDeclaration, ObjectKeyBuilder keyBuilder) {
        XSTypeDefinition typeDefinition = elementDeclaration.getTypeDefinition();
        if (typeDefinition instanceof XSComplexTypeDecl) {
            XSObjectList attributeUses = ((XSComplexTypeDefinition)typeDefinition).getAttributeUses();
            for (Object attributeUse : attributeUses) {
                if (!(attributeUse instanceof XSAttributeUse)) continue;
                XSAttributeUse xsAttributeUse = (XSAttributeUse)attributeUse;
                XSAttributeDeclaration attrDeclaration = xsAttributeUse.getAttrDeclaration();
                String localName = attrDeclaration.getName();
                String namespace = attrDeclaration.getNamespace();
                AttributeFieldTypeBuilder attributeField = keyBuilder.addAttribute();
                attributeField.name(new QName(namespace, localName));
                attributeField.required(xsAttributeUse.getRequired());
                this.handlerManager.handle((XSSimpleTypeDecl)attrDeclaration.getTypeDefinition(), SchemaHelper.getDefaultValue(xsAttributeUse), attributeField.value());
            }
        }
    }

    private void processElements(XSComplexTypeDecl complexType, ObjectTypeBuilder objectType) {
        XSTerm term;
        XSParticle particle = complexType.getParticle();
        if (particle != null && (term = particle.getTerm()) instanceof XSModelGroup) {
            XSModelGroup xsModelGroup = (XSModelGroup)term;
            objectType.ordered(xsModelGroup.getCompositor() == 1);
            XSObjectList particles = xsModelGroup.getParticles();
            for (Object xsObject : particles) {
                if (!(xsObject instanceof XSParticle)) continue;
                XSParticle part = (XSParticle)xsObject;
                XSTerm element = part.getTerm();
                if (element instanceof XSElementDeclaration) {
                    XSTypeDefinition typeDefinition;
                    Optional<QName> typeName;
                    XSElementDeclaration xsElementDeclaration = (XSElementDeclaration)element;
                    String name = element.getName();
                    String namespace = element.getNamespace();
                    ObjectFieldTypeBuilder field = objectType.addField();
                    this.processAttributes(xsElementDeclaration, field.key(new QName(namespace, name)));
                    field.required(part.getMinOccurs() > 0);
                    field.repeated(this.isRepeated(part));
                    Integer min = null;
                    Integer max = null;
                    if (part.getMinOccurs() > 1) {
                        min = part.getMinOccurs();
                    }
                    if (part.getMaxOccurs() > 1) {
                        max = part.getMaxOccurs();
                    }
                    if (MetadataTypeUtils.isNotNull((Object)min) || MetadataTypeUtils.isNotNull((Object)max)) {
                        field.occurrence((Number)min, (Number)max);
                    }
                    if ((typeName = this.getTypeName(typeDefinition = ((XSElementDeclaration)element).getTypeDefinition())).isPresent() && this.types.containsKey(typeName.get())) {
                        field.value(this.types.get(typeName.get()));
                        continue;
                    }
                    BaseTypeBuilder fieldValue = field.value();
                    this.processValue(xsElementDeclaration, fieldValue);
                    continue;
                }
                if (!(element instanceof XSWildcard) || ((XSWildcard)element).getConstraintType() != 1) continue;
                objectType.open();
            }
        }
    }

    private Optional<QName> getTypeName(XSTypeDefinition typeDefinition) {
        TypeInfo definition;
        Optional<QName> typeQname = Optional.empty();
        if (typeDefinition instanceof TypeInfo && (definition = (TypeInfo)typeDefinition).getTypeName() != null) {
            typeQname = Optional.of(new QName(definition.getTypeNamespace(), definition.getTypeName()));
        }
        return typeQname;
    }

    private boolean isRepeated(XSParticle part) {
        return part.getMaxOccursUnbounded() || part.getMaxOccurs() > 1 || part.getMinOccurs() > 1;
    }
}

