/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml.internal.util;

import java.io.File;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.common.ValidationResult;

public class RamlLoaderUtils {
    public static RamlModelResult buildApiOrFail(File ramlFile) {
        RamlModelResult ramlModelResult = new RamlModelBuilder().buildApi(ramlFile);
        RamlLoaderUtils.assertRamlModelResult(ramlModelResult, ramlFile.getPath());
        return ramlModelResult;
    }

    public static RamlModelResult buildApiOrFail(String content, String ramlLocation) {
        RamlModelResult ramlModelResult = new RamlModelBuilder().buildApi(content, ramlLocation);
        RamlLoaderUtils.assertRamlModelResult(ramlModelResult, ramlLocation);
        return ramlModelResult;
    }

    private static void assertRamlModelResult(RamlModelResult ramlModelResult, String ramlLocation) {
        if (ramlModelResult.hasErrors()) {
            StringBuilder sb = new StringBuilder(String.format("There are [%d] errors in the RAML [%s]. Full list:", ramlModelResult.getValidationResults().size(), ramlLocation));
            for (ValidationResult validationResult : ramlModelResult.getValidationResults()) {
                sb.append(String.format("\nMessage:[%s]. Path:[%s]", validationResult.getMessage(), validationResult.getPath()));
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

