/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml.internal.fragments.handler;

import java.util.Optional;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.raml.internal.fragments.handler.ParsingContext;
import org.mule.metadata.raml.internal.fragments.handler.TypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.TypeDeclarationHandlerManager;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class ArrayTypeDeclarationHandler
implements TypeDeclarationHandler {
    @Override
    public boolean handles(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof ArrayTypeDeclaration;
    }

    @Override
    public TypeBuilder<?> handle(TypeDeclaration typeDeclaration, BaseTypeBuilder root, TypeDeclarationHandlerManager typeDeclarationHandlerManager, ParsingContext parsingContext) {
        Optional<Boolean> uniqueItems;
        ArrayTypeDeclaration arrayTypeDeclaration = (ArrayTypeDeclaration)typeDeclaration;
        ArrayTypeBuilder arrayTypeBuilder = root.arrayType();
        arrayTypeBuilder.of(typeDeclarationHandlerManager.handle(arrayTypeDeclaration.items(), parsingContext));
        Optional<Integer> maxItems = Optional.ofNullable(arrayTypeDeclaration.maxItems());
        Optional<Integer> minItems = Optional.ofNullable(arrayTypeDeclaration.minItems());
        if (maxItems.isPresent() && minItems.isPresent()) {
            arrayTypeBuilder.boundary((Number)minItems.get(), (Number)maxItems.get());
        }
        if ((uniqueItems = Optional.ofNullable(arrayTypeDeclaration.uniqueItems())).isPresent()) {
            arrayTypeBuilder.uniques();
        }
        return arrayTypeBuilder;
    }
}

