/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

final class BidirectionalMap<K, V>
implements Map<K, V> {
    private final Map<K, V> forward;
    private final Map<V, K> backward;

    private BidirectionalMap(Map<K, V> forward, Map<V, K> backward) {
        this.forward = forward;
        this.backward = backward;
    }

    public static <K, V> BidirectionalMap<K, V> create() {
        return new BidirectionalMap(new LinkedHashMap(), new LinkedHashMap());
    }

    @Override
    public int size() {
        return this.forward.size();
    }

    @Override
    public boolean isEmpty() {
        return this.forward.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forward.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.forward.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.forward.get(key);
    }

    @Override
    public V put(K key, V value) {
        V oldValue = null;
        if (this.forward.containsKey(key)) {
            oldValue = this.forward.get(key);
            this.backward.remove(oldValue);
        }
        if (this.backward.containsKey(value)) {
            K oldKey = this.backward.get(value);
            this.forward.remove(oldKey);
        }
        this.forward.put(key, value);
        this.backward.put(value, key);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V value = this.forward.remove(key);
        if (value != null) {
            this.backward.remove(value);
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.forward.clear();
        this.backward.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.forward.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.forward.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.forward.entrySet();
    }

    public BidirectionalMap<V, K> inverse() {
        return new BidirectionalMap<V, K>(this.backward, this.forward);
    }
}

