/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.serializer;

import com.google.gson.stream.JsonWriter;
import java.util.Stack;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.serializer.BaseTypeSerializer;

public abstract class AbstractComplexTypeSerializer<T extends MetadataType>
extends BaseTypeSerializer<T> {
    AbstractComplexTypeSerializer(String typeName) {
        super(typeName);
    }

    @Override
    public void serialize(JsonWriter writer, T type, Stack<MetadataType> typeStack) {
        if (typeStack.contains(type)) {
            this.handleRecursion(writer, (MetadataType)type, typeStack);
        } else {
            super.serialize(writer, type, typeStack);
        }
    }

    private void handleRecursion(JsonWriter writer, MetadataType type, Stack<MetadataType> typeStack) {
        int indexOf = typeStack.indexOf(type);
        int reference = typeStack.size() - indexOf;
        StringBuilder ref = new StringBuilder("#");
        for (int i = 0; i < reference; ++i) {
            if (i > 0) {
                ref.append("/");
            }
            ref.append("..");
        }
        try {
            writer.value(ref.toString());
        }
        catch (Exception e) {
            throw new MetadataSerializingException("recursive" + this.typeName + " MetadataType", e);
        }
    }
}

